/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.slack;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.slack.SlackService;
import org.elasticsearch.xpack.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.slack.ExecutableSlackAction;
import org.elasticsearch.xpack.watcher.actions.slack.SlackAction;

public class SlackActionFactory
extends ActionFactory {
    private final TextTemplateEngine templateEngine;
    private final SlackService slackService;

    public SlackActionFactory(Settings settings, TextTemplateEngine templateEngine, SlackService slackService) {
        super(Loggers.getLogger(ExecutableSlackAction.class, settings, new String[0]));
        this.templateEngine = templateEngine;
        this.slackService = slackService;
    }

    @Override
    public ExecutableSlackAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        SlackAction action = SlackAction.parse(watchId, actionId, parser);
        this.slackService.getAccount(action.account);
        return new ExecutableSlackAction(action, this.actionLogger, this.slackService, this.templateEngine);
    }
}

