/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.index;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.index.ExecutableIndexAction;
import org.elasticsearch.xpack.watcher.actions.index.IndexAction;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;

public class IndexActionFactory
extends ActionFactory {
    private final WatcherClientProxy client;
    private final TimeValue defaultTimeout;

    public IndexActionFactory(Settings settings, InternalClient client) {
        this(settings, new WatcherClientProxy(settings, client));
    }

    public IndexActionFactory(Settings settings, WatcherClientProxy client) {
        super(Loggers.getLogger(IndexActionFactory.class, settings, new String[0]));
        this.client = client;
        this.defaultTimeout = settings.getAsTime("xpack.watcher.actions.index.default_timeout", null);
    }

    @Override
    public ExecutableIndexAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        return new ExecutableIndexAction(IndexAction.parse(watchId, actionId, parser), this.actionLogger, this.client, this.defaultTimeout);
    }
}

