/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.hipchat;

import java.util.Map;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.hipchat.HipChatAccount;
import org.elasticsearch.xpack.notification.hipchat.HipChatMessage;
import org.elasticsearch.xpack.notification.hipchat.HipChatService;
import org.elasticsearch.xpack.notification.hipchat.SentMessages;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.watcher.actions.hipchat.HipChatAction;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableHipChatAction
extends ExecutableAction<HipChatAction> {
    private final TextTemplateEngine templateEngine;
    private final HipChatService hipchatService;

    public ExecutableHipChatAction(HipChatAction action, Logger logger, HipChatService hipchatService, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.hipchatService = hipchatService;
        this.templateEngine = templateEngine;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        HipChatAccount account = (HipChatAccount)this.hipchatService.getAccount(((HipChatAction)this.action).account);
        account.validateParsedTemplate(ctx.id().watchId(), actionId, ((HipChatAction)this.action).message);
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        HipChatMessage message = account.render(ctx.id().watchId(), actionId, this.templateEngine, ((HipChatAction)this.action).message, model);
        if (ctx.simulateAction(actionId)) {
            return new HipChatAction.Result.Simulated(message);
        }
        SentMessages sentMessages = account.send(message, ((HipChatAction)this.action).proxy);
        return new HipChatAction.Result.Executed(sentMessages);
    }
}

