/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public class WatcherBuild {
    public static final WatcherBuild CURRENT;
    private final String versionName;
    private final String hash;
    private final String hashShort;
    private final String timestamp;

    WatcherBuild(String versionName, String hash, String hashShort, String timestamp) {
        this.versionName = versionName;
        this.hash = hash;
        this.hashShort = hashShort;
        this.timestamp = timestamp;
    }

    public String versionName() {
        return this.versionName;
    }

    public String hash() {
        return this.hash;
    }

    public String hashShort() {
        return this.hashShort;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatcherBuild that = (WatcherBuild)o;
        if (!this.hash.equals(that.hash)) {
            return false;
        }
        if (!this.hashShort.equals(that.hashShort)) {
            return false;
        }
        if (!this.timestamp.equals(that.timestamp)) {
            return false;
        }
        return this.versionName.equals(that.versionName);
    }

    public int hashCode() {
        int result = this.hash.hashCode();
        result = 31 * result + this.hashShort.hashCode();
        result = 31 * result + this.timestamp.hashCode();
        result = 31 * result + this.versionName.hashCode();
        return result;
    }

    public static WatcherBuild readBuild(StreamInput in) throws IOException {
        String versionName = in.readString();
        String hash = in.readString();
        String hashShort = in.readString();
        String timestamp = in.readString();
        return new WatcherBuild(versionName, hash, hashShort, timestamp);
    }

    public static void writeBuild(WatcherBuild build, StreamOutput out) throws IOException {
        out.writeString(build.versionName);
        out.writeString(build.hash);
        out.writeString(build.hashShort);
        out.writeString(build.timestamp);
    }

    static {
        String versionName = "NA";
        String hash = "NA";
        String hashShort = "NA";
        String timestamp = "NA";
        try (InputStream is = WatcherBuild.class.getResourceAsStream("/watcher-build.properties");){
            String gitTimestampRaw;
            Properties props = new Properties();
            props.load(is);
            hash = props.getProperty("hash", hash);
            if (!hash.equals("NA")) {
                hashShort = hash.substring(0, 7);
            }
            if ((gitTimestampRaw = props.getProperty("timestamp")) != null) {
                timestamp = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC).print(Long.parseLong(gitTimestampRaw));
            }
            versionName = props.getProperty("version", "NA");
        }
        catch (Exception exception) {
            // empty catch block
        }
        CURRENT = new WatcherBuild(versionName, hash, hashShort, timestamp);
    }
}

