/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CharArrays;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.ssl.SSLService;

class LdapUserSearchSessionFactory
extends SessionFactory {
    static final int DEFAULT_CONNECTION_POOL_SIZE = 20;
    static final int DEFAULT_CONNECTION_POOL_INITIAL_SIZE = 0;
    static final String DEFAULT_USERNAME_ATTRIBUTE = "uid";
    static final TimeValue DEFAULT_HEALTH_CHECK_INTERVAL = TimeValue.timeValueSeconds(60L);
    static final String SEARCH_PREFIX = "user_search.";
    private static final Setting<String> SEARCH_BASE_DN = Setting.simpleString("user_search.base_dn", Setting.Property.NodeScope);
    private static final Setting<String> SEARCH_ATTRIBUTE = new Setting("user_search.attribute", "uid", Function.identity(), Setting.Property.NodeScope);
    private static final Setting<LdapSearchScope> SEARCH_SCOPE = new Setting<LdapSearchScope>("user_search.scope", (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), Setting.Property.NodeScope);
    private static final Setting<Boolean> POOL_ENABLED = Setting.boolSetting("user_search.pool.enabled", true, Setting.Property.NodeScope);
    private static final Setting<Integer> POOL_INITIAL_SIZE = Setting.intSetting("user_search.pool.initial_size", 0, 0, Setting.Property.NodeScope);
    private static final Setting<Integer> POOL_SIZE = Setting.intSetting("user_search.pool.size", 20, 1, Setting.Property.NodeScope);
    private static final Setting<TimeValue> HEALTH_CHECK_INTERVAL = Setting.timeSetting("user_search.pool.health_check.interval", DEFAULT_HEALTH_CHECK_INTERVAL, Setting.Property.NodeScope);
    private static final Setting<Boolean> HEALTH_CHECK_ENABLED = Setting.boolSetting("user_search.pool.health_check.enabled", true, Setting.Property.NodeScope);
    private static final Setting<Optional<String>> HEALTH_CHECK_DN = new Setting<Optional>("user_search.pool.health_check.dn", (String)null, Optional::ofNullable, Setting.Property.NodeScope);
    private static final Setting<String> BIND_DN = Setting.simpleString("bind_dn", Setting.Property.NodeScope);
    private static final Setting<String> BIND_PASSWORD = Setting.simpleString("bind_password", Setting.Property.NodeScope);
    private final String userSearchBaseDn;
    private final LdapSearchScope scope;
    private final String userAttribute;
    private final LdapSession.GroupsResolver groupResolver;
    private final boolean useConnectionPool;
    private final LDAPConnectionPool connectionPool;

    LdapUserSearchSessionFactory(RealmConfig config, SSLService sslService) throws LDAPException {
        super(config, sslService);
        Settings settings = config.settings();
        if (!SEARCH_BASE_DN.exists(settings)) {
            throw new IllegalArgumentException("[" + RealmSettings.getFullSettingKey(config, SEARCH_BASE_DN) + "] must be specified");
        }
        this.userSearchBaseDn = SEARCH_BASE_DN.get(settings);
        this.scope = SEARCH_SCOPE.get(settings);
        this.userAttribute = SEARCH_ATTRIBUTE.get(settings);
        this.groupResolver = LdapUserSearchSessionFactory.groupResolver(settings);
        this.useConnectionPool = POOL_ENABLED.get(settings);
        this.connectionPool = this.useConnectionPool ? LdapUserSearchSessionFactory.createConnectionPool(config, this.serverSet, this.timeout, this.logger) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LDAPConnectionPool createConnectionPool(RealmConfig config, ServerSet serverSet, TimeValue timeout, Logger logger) throws LDAPException {
        Settings settings = config.settings();
        SimpleBindRequest bindRequest = LdapUserSearchSessionFactory.bindRequest(settings);
        int initialSize = POOL_INITIAL_SIZE.get(settings);
        int size = POOL_SIZE.get(settings);
        LDAPConnectionPool pool = null;
        boolean success = false;
        try {
            pool = new LDAPConnectionPool(serverSet, bindRequest, initialSize, size);
            pool.setRetryFailedOperationsDueToInvalidConnections(true);
            if (HEALTH_CHECK_ENABLED.get(settings).booleanValue()) {
                String entryDn = HEALTH_CHECK_DN.get(settings).orElseGet(() -> bindRequest == null ? null : bindRequest.getBindDN());
                long healthCheckInterval = HEALTH_CHECK_INTERVAL.get(settings).millis();
                if (entryDn != null) {
                    GetEntryLDAPConnectionPoolHealthCheck healthCheck = new GetEntryLDAPConnectionPoolHealthCheck(entryDn, timeout.millis(), false, false, false, true, false);
                    pool.setHealthCheck(healthCheck);
                    pool.setHealthCheckIntervalMillis(healthCheckInterval);
                } else {
                    logger.warn("[" + RealmSettings.getFullSettingKey(config, BIND_DN) + "] and [" + RealmSettings.getFullSettingKey(config, HEALTH_CHECK_DN) + "] have not been specified so no ldap query will be run as a health check");
                }
            }
            success = true;
            LDAPConnectionPool lDAPConnectionPool = pool;
            return lDAPConnectionPool;
        }
        finally {
            if (!success && pool != null) {
                pool.close();
            }
        }
    }

    static SimpleBindRequest bindRequest(Settings settings) {
        SimpleBindRequest request = null;
        if (BIND_DN.exists(settings)) {
            request = new SimpleBindRequest(BIND_DN.get(settings), BIND_PASSWORD.get(settings));
        }
        return request;
    }

    public static boolean hasUserSearchSettings(RealmConfig config) {
        return !config.settings().getByPrefix(SEARCH_PREFIX).isEmpty();
    }

    @Override
    public void session(String user, SecuredString password, ActionListener<LdapSession> listener) {
        if (this.useConnectionPool) {
            this.getSessionWithPool(user, password, listener);
        } else {
            this.getSessionWithoutPool(user, password, listener);
        }
    }

    private void getSessionWithPool(String user, SecuredString password, ActionListener<LdapSession> listener) {
        this.findUser(user, this.connectionPool, ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                try {
                    this.connectionPool.bindAndRevertAuthentication(dn, new String(password.internalChars()), new Control[0]);
                    listener.onResponse(new LdapSession(this.logger, this.connectionPool, dn, this.groupResolver, this.timeout, entry.getAttributes()));
                }
                catch (LDAPException e) {
                    listener.onFailure(e);
                }
            }
        }, listener::onFailure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSessionWithoutPool(String user, SecuredString password, ActionListener<LdapSession> listener) {
        boolean success = false;
        LDAPConnection connection = null;
        try {
            connection = this.serverSet.getConnection();
            connection.bind(LdapUserSearchSessionFactory.bindRequest(this.config.settings()));
            LDAPConnection finalConnection = connection;
            this.findUser(user, connection, ActionListener.wrap(entry -> {
                IOUtils.close(finalConnection);
                if (entry == null) {
                    listener.onResponse(null);
                    return;
                }
                String dn = entry.getDN();
                boolean sessionCreated = false;
                LDAPConnection userConnection = null;
                byte[] passwordBytes = CharArrays.toUtf8Bytes(password.internalChars());
                try {
                    userConnection = this.serverSet.getConnection();
                    userConnection.bind(new SimpleBindRequest(dn, passwordBytes));
                    LdapSession session = new LdapSession(this.logger, userConnection, dn, this.groupResolver, this.timeout, entry.getAttributes());
                    sessionCreated = true;
                    listener.onResponse(session);
                }
                catch (Exception e) {
                    try {
                        listener.onFailure(e);
                    }
                    catch (Throwable throwable) {
                        Arrays.fill(passwordBytes, (byte)0);
                        if (sessionCreated) throw throwable;
                        IOUtils.close(userConnection);
                        throw throwable;
                    }
                    Arrays.fill(passwordBytes, (byte)0);
                    if (sessionCreated) return;
                    IOUtils.close(userConnection);
                    return;
                }
                Arrays.fill(passwordBytes, (byte)0);
                if (sessionCreated) return;
                IOUtils.close(userConnection);
                return;
            }, e -> {
                IOUtils.closeWhileHandlingException(finalConnection);
                listener.onFailure((Exception)e);
            }));
            return;
        }
        catch (LDAPException e2) {
            try {
                listener.onFailure(e2);
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(connection);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(connection);
            return;
        }
    }

    @Override
    public boolean supportsUnauthenticatedSession() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unauthenticatedSession(String user, ActionListener<LdapSession> listener) {
        LDAPConnection connection = null;
        boolean success = false;
        try {
            void var5_7;
            if (this.useConnectionPool) {
                LDAPConnectionPool lDAPConnectionPool = this.connectionPool;
            } else {
                connection = this.serverSet.getConnection();
                connection.bind(LdapUserSearchSessionFactory.bindRequest(this.config.settings()));
                LDAPConnection lDAPConnection = connection;
            }
            this.findUser(user, (LDAPInterface)var5_7, ActionListener.wrap(arg_0 -> this.lambda$unauthenticatedSession$5(listener, (LDAPInterface)var5_7, arg_0), listener::onFailure));
            return;
        }
        catch (LDAPException lDAPException) {
            try {
                listener.onFailure(lDAPException);
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(connection);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(connection);
            return;
        }
    }

    private void findUser(String user, LDAPInterface ldapInterface, ActionListener<SearchResultEntry> listener) {
        LdapUtils.searchForEntry(ldapInterface, this.userSearchBaseDn, this.scope.scope(), Filter.createEqualityFilter(this.userAttribute, Filter.encodeValue(user)), Math.toIntExact(this.timeout.seconds()), listener, LdapUtils.attributesToSearchFor(this.groupResolver.attributes()));
    }

    void shutdown() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
        }
    }

    static LdapSession.GroupsResolver groupResolver(Settings settings) {
        if (SearchGroupsResolver.BASE_DN.exists(settings)) {
            return new SearchGroupsResolver(settings);
        }
        return new UserAttributeGroupsResolver(settings);
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactory.getSettings());
        settings.add(SEARCH_BASE_DN);
        settings.add(SEARCH_SCOPE);
        settings.add(SEARCH_ATTRIBUTE);
        settings.add(POOL_ENABLED);
        settings.add(POOL_INITIAL_SIZE);
        settings.add(POOL_SIZE);
        settings.add(HEALTH_CHECK_ENABLED);
        settings.add(HEALTH_CHECK_DN);
        settings.add(HEALTH_CHECK_INTERVAL);
        settings.add(BIND_DN);
        settings.add(BIND_PASSWORD);
        settings.addAll(SearchGroupsResolver.getSettings());
        settings.addAll(UserAttributeGroupsResolver.getSettings());
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$unauthenticatedSession$5(ActionListener listener, LDAPInterface ldapInterface, SearchResultEntry entry) throws Exception {
        if (entry == null) {
            listener.onResponse(null);
            return;
        }
        boolean sessionCreated = false;
        try {
            String dn = entry.getDN();
            LdapSession session = new LdapSession(this.logger, ldapInterface, dn, this.groupResolver, this.timeout, entry.getAttributes());
            sessionCreated = true;
            listener.onResponse(session);
            if (sessionCreated) return;
            if (this.useConnectionPool) return;
        }
        catch (Throwable throwable) {
            if (sessionCreated) throw throwable;
            if (this.useConnectionPool) throw throwable;
            IOUtils.close((LDAPConnection)ldapInterface);
            throw throwable;
        }
        IOUtils.close((LDAPConnection)ldapInterface);
    }
}

