/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectoryGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.ssl.SSLService;

class ActiveDirectorySessionFactory
extends SessionFactory {
    static final String AD_DOMAIN_NAME_SETTING = "domain_name";
    static final String AD_GROUP_SEARCH_BASEDN_SETTING = "group_search.base_dn";
    static final String AD_GROUP_SEARCH_SCOPE_SETTING = "group_search.scope";
    static final String AD_USER_SEARCH_BASEDN_SETTING = "user_search.base_dn";
    static final String AD_USER_SEARCH_FILTER_SETTING = "user_search.filter";
    static final String AD_USER_SEARCH_SCOPE_SETTING = "user_search.scope";
    private static final String NETBIOS_NAME_FILTER_TEMPLATE = "(netbiosname={0})";
    private final DefaultADAuthenticator defaultADAuthenticator;
    private final DownLevelADAuthenticator downLevelADAuthenticator;
    private final UpnADAuthenticator upnADAuthenticator;

    ActiveDirectorySessionFactory(RealmConfig config, SSLService sslService) {
        super(config, sslService);
        Settings settings = config.settings();
        String domainName = settings.get(AD_DOMAIN_NAME_SETTING);
        if (domainName == null) {
            throw new IllegalArgumentException("missing [domain_name] setting for active directory");
        }
        String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(domainName);
        ActiveDirectoryGroupsResolver groupResolver = new ActiveDirectoryGroupsResolver(settings.getAsSettings("group_search"), domainDN);
        this.defaultADAuthenticator = new DefaultADAuthenticator(settings, this.timeout, this.logger, groupResolver, domainDN);
        this.downLevelADAuthenticator = new DownLevelADAuthenticator(config, this.timeout, this.logger, groupResolver, domainDN, sslService);
        this.upnADAuthenticator = new UpnADAuthenticator(settings, this.timeout, this.logger, groupResolver, domainDN);
    }

    @Override
    protected String[] getDefaultLdapUrls(Settings settings) {
        return new String[]{"ldap://" + settings.get(AD_DOMAIN_NAME_SETTING) + ":389"};
    }

    @Override
    public void session(String username, SecuredString password, ActionListener<LdapSession> listener) {
        Runnable runnable;
        try {
            LDAPConnection connection = this.serverSet.getConnection();
            runnable = () -> this.getADAuthenticator(username).authenticate(connection, username, password, ActionListener.wrap(listener::onResponse, e -> {
                IOUtils.closeWhileHandlingException(connection);
                listener.onFailure((Exception)e);
            }));
        }
        catch (LDAPException e) {
            runnable = () -> listener.onFailure(e);
        }
        runnable.run();
    }

    static String buildDnFromDomain(String domain) {
        return "DC=" + domain.replace(".", ",DC=");
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactory.getSettings());
        settings.add(Setting.simpleString(AD_DOMAIN_NAME_SETTING, Setting.Property.NodeScope));
        settings.add(Setting.simpleString(AD_GROUP_SEARCH_BASEDN_SETTING, Setting.Property.NodeScope));
        settings.add(Setting.simpleString(AD_GROUP_SEARCH_SCOPE_SETTING, Setting.Property.NodeScope));
        settings.add(Setting.simpleString(AD_USER_SEARCH_BASEDN_SETTING, Setting.Property.NodeScope));
        settings.add(Setting.simpleString(AD_USER_SEARCH_FILTER_SETTING, Setting.Property.NodeScope));
        settings.add(Setting.simpleString(AD_USER_SEARCH_SCOPE_SETTING, Setting.Property.NodeScope));
        return settings;
    }

    ADAuthenticator getADAuthenticator(String username) {
        if (username.indexOf(92) > 0) {
            return this.downLevelADAuthenticator;
        }
        if (username.indexOf("@") > 0) {
            return this.upnADAuthenticator;
        }
        return this.defaultADAuthenticator;
    }

    static class UpnADAuthenticator
    extends ADAuthenticator {
        private static final String UPN_USER_FILTER = "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={1})))";

        UpnADAuthenticator(Settings settings, TimeValue timeout, Logger logger, LdapSession.GroupsResolver groupsResolver, String domainDN) {
            super(settings, timeout, logger, groupsResolver, domainDN);
        }

        @Override
        void searchForDN(LDAPConnection connection, String username, SecuredString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("@");
            assert (parts.length == 2);
            String accountName = parts[0];
            String domainName = parts[1];
            String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(domainName);
            try {
                Filter filter = LdapUtils.createFilter(UPN_USER_FILTER, accountName, username);
                LdapUtils.searchForEntry(connection, domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure(e);
            }
        }
    }

    static class DownLevelADAuthenticator
    extends ADAuthenticator {
        Cache<String, String> domainNameCache = CacheBuilder.builder().setMaximumWeight(100L).build();
        final String domainDN;
        final Settings settings;
        final SSLService sslService;
        final RealmConfig config;

        DownLevelADAuthenticator(RealmConfig config, TimeValue timeout, Logger logger, LdapSession.GroupsResolver groupsResolver, String domainDN, SSLService sslService) {
            super(config.settings(), timeout, logger, groupsResolver, domainDN);
            this.domainDN = domainDN;
            this.settings = config.settings();
            this.sslService = sslService;
            this.config = config;
        }

        @Override
        void searchForDN(LDAPConnection connection, String username, SecuredString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("\\\\");
            assert (parts.length == 2);
            String netBiosDomainName = parts[0];
            String accountName = parts[1];
            this.netBiosDomainNameToDn(connection, netBiosDomainName, username, password, timeLimitSeconds, ActionListener.wrap(domainDN -> {
                if (domainDN == null) {
                    IOUtils.close(connection);
                    listener.onResponse(null);
                } else {
                    try {
                        LdapUtils.searchForEntry(connection, domainDN, LdapSearchScope.SUB_TREE.scope(), LdapUtils.createFilter("(&(objectClass=user)(sAMAccountName={0}))", accountName), timeLimitSeconds, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
                    }
                    catch (LDAPException e) {
                        IOUtils.closeWhileHandlingException(connection);
                        listener.onFailure(e);
                    }
                }
            }, e -> {
                IOUtils.closeWhileHandlingException(connection);
                listener.onFailure((Exception)e);
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void netBiosDomainNameToDn(LDAPConnection connection, String netBiosDomainName, String username, SecuredString password, int timeLimitSeconds, ActionListener<String> listener) {
            String cachedName = this.domainNameCache.get(netBiosDomainName);
            if (cachedName != null) {
                listener.onResponse(cachedName);
                return;
            }
            if (DownLevelADAuthenticator.usingGlobalCatalog(this.settings, connection)) {
                LDAPConnectionOptions options = ActiveDirectorySessionFactory.connectionOptions(this.config, this.sslService, this.logger);
                boolean startedSearching = false;
                LDAPConnection searchConnection = null;
                try {
                    Filter filter = LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName);
                    searchConnection = connection.getSSLSession() != null ? new LDAPConnection(connection.getSocketFactory(), options, connection.getConnectedAddress(), 636) : new LDAPConnection(options, connection.getConnectedAddress(), 389);
                    searchConnection.bind(username, new String(password.internalChars()));
                    LDAPConnection finalConnection = searchConnection;
                    LdapUtils.search(finalConnection, this.domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, ActionListener.wrap(results -> {
                        IOUtils.close(finalConnection);
                        DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, this.domainNameCache, listener);
                    }, e -> {
                        IOUtils.closeWhileHandlingException(connection);
                        listener.onFailure((Exception)e);
                    }), "ncname");
                    return;
                }
                catch (LDAPException e2) {
                    try {
                        listener.onFailure(e2);
                        if (startedSearching) return;
                    }
                    catch (Throwable throwable) {
                        if (startedSearching) throw throwable;
                        IOUtils.closeWhileHandlingException(searchConnection);
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(searchConnection);
                    return;
                }
            }
            try {
                Filter filter = LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName);
                LdapUtils.search(connection, this.domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, ActionListener.wrap(results -> DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, this.domainNameCache, listener), e -> {
                    IOUtils.closeWhileHandlingException(connection);
                    listener.onFailure((Exception)e);
                }), "ncname");
                return;
            }
            catch (LDAPException e3) {
                listener.onFailure(e3);
            }
        }

        static void handleSearchResults(List<SearchResultEntry> results, String netBiosDomainName, Cache<String, String> domainNameCache, ActionListener<String> listener) {
            Optional<SearchResultEntry> entry = results.stream().filter(r -> r.hasAttribute("ncname")).findFirst();
            if (entry.isPresent()) {
                String value = entry.get().getAttributeValue("ncname");
                try {
                    domainNameCache.computeIfAbsent(netBiosDomainName, s -> value);
                }
                catch (ExecutionException e) {
                    throw new AssertionError("failed to load constant non-null value", e);
                }
                listener.onResponse(value);
            } else {
                listener.onResponse(null);
            }
        }

        static boolean usingGlobalCatalog(Settings settings, LDAPConnection ldapConnection) {
            Boolean usingGlobalCatalog = settings.getAsBoolean("global_catalog", null);
            if (usingGlobalCatalog != null) {
                return usingGlobalCatalog;
            }
            return ldapConnection.getConnectedPort() == 3268 || ldapConnection.getConnectedPort() == 3269;
        }
    }

    static class DefaultADAuthenticator
    extends ADAuthenticator {
        final String userSearchFilter;
        final String domainName;

        DefaultADAuthenticator(Settings settings, TimeValue timeout, Logger logger, LdapSession.GroupsResolver groupsResolver, String domainDN) {
            super(settings, timeout, logger, groupsResolver, domainDN);
            this.domainName = settings.get(ActiveDirectorySessionFactory.AD_DOMAIN_NAME_SETTING);
            this.userSearchFilter = settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_FILTER_SETTING, "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={0}@" + this.domainName + ")))");
        }

        @Override
        void searchForDN(LDAPConnection connection, String username, SecuredString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            try {
                LdapUtils.searchForEntry(connection, this.userSearchDN, this.userSearchScope.scope(), LdapUtils.createFilter(this.userSearchFilter, username), timeLimitSeconds, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure(e);
            }
        }

        @Override
        String bindUsername(String username) {
            return username + "@" + this.domainName;
        }
    }

    static abstract class ADAuthenticator {
        final TimeValue timeout;
        final Logger logger;
        final LdapSession.GroupsResolver groupsResolver;
        final String userSearchDN;
        final LdapSearchScope userSearchScope;

        ADAuthenticator(Settings settings, TimeValue timeout, Logger logger, LdapSession.GroupsResolver groupsResolver, String domainDN) {
            this.timeout = timeout;
            this.logger = logger;
            this.groupsResolver = groupsResolver;
            this.userSearchDN = settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_BASEDN_SETTING, domainDN);
            this.userSearchScope = LdapSearchScope.resolve(settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_SCOPE_SETTING), LdapSearchScope.SUB_TREE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void authenticate(LDAPConnection connection, String username, SecuredString password, ActionListener<LdapSession> listener) {
            boolean success = false;
            try {
                connection.bind(this.bindUsername(username), new String(password.internalChars()));
                this.searchForDN(connection, username, password, Math.toIntExact(this.timeout.seconds()), ActionListener.wrap(entry -> {
                    if (entry == null) {
                        IOUtils.close(connection);
                        listener.onFailure(new ElasticsearchSecurityException("search for user [" + username + "] by principle name yielded no results", new Object[0]));
                    } else {
                        String dn = entry.getDN();
                        listener.onResponse(new LdapSession(this.logger, connection, dn, this.groupsResolver, this.timeout, null));
                    }
                }, e -> {
                    IOUtils.closeWhileHandlingException(connection);
                    listener.onFailure((Exception)e);
                }));
                return;
            }
            catch (LDAPException e2) {
                try {
                    listener.onFailure(e2);
                    if (success) return;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IOUtils.closeWhileHandlingException(connection);
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(connection);
                return;
            }
        }

        String bindUsername(String username) {
            return username;
        }

        abstract void searchForDN(LDAPConnection var1, String var2, SecuredString var3, int var4, ActionListener<SearchResultEntry> var5);
    }
}

