/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class ActiveDirectoryGroupsResolver
implements LdapSession.GroupsResolver {
    private static final String TOKEN_GROUPS = "tokenGroups";
    private final String baseDn;
    private final LdapSearchScope scope;

    ActiveDirectoryGroupsResolver(Settings settings, String baseDnDefault) {
        this.baseDn = settings.get("base_dn", baseDnDefault);
        this.scope = LdapSearchScope.resolve(settings.get("scope"), LdapSearchScope.SUB_TREE);
    }

    @Override
    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<List<String>> listener) {
        ActiveDirectoryGroupsResolver.buildGroupQuery(connection, userDn, timeout, ActionListener.wrap(filter -> {
            if (filter == null) {
                listener.onResponse(Collections.emptyList());
            } else {
                logger.debug("group SID to DN [{}] search filter: [{}]", (Object)userDn, filter);
                LdapUtils.search(connection, this.baseDn, this.scope.scope(), filter, Math.toIntExact(timeout.seconds()), ActionListener.wrap(results -> {
                    List groups = results.stream().map(Entry::getDN).collect(Collectors.toList());
                    listener.onResponse(Collections.unmodifiableList(groups));
                }, listener::onFailure), "1.1");
            }
        }, listener::onFailure));
    }

    @Override
    public String[] attributes() {
        return null;
    }

    static void buildGroupQuery(LDAPInterface connection, String userDn, TimeValue timeout, ActionListener<Filter> listener) {
        LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), ActionListener.wrap(entry -> {
            if (entry == null || !entry.hasAttribute(TOKEN_GROUPS)) {
                listener.onResponse(null);
            } else {
                byte[][] tokenGroupSIDBytes = entry.getAttributeValueByteArrays(TOKEN_GROUPS);
                List<Filter> orFilters = Arrays.stream(tokenGroupSIDBytes).map(sidBytes -> Filter.createEqualityFilter("objectSid", ActiveDirectoryGroupsResolver.binarySidToStringSid(sidBytes))).collect(Collectors.toList());
                listener.onResponse(Filter.createORFilter(orFilters));
            }
        }, listener::onFailure), TOKEN_GROUPS);
    }

    private static String binarySidToStringSid(byte[] SID) {
        String strSID = "S";
        long version = SID[0];
        strSID = strSID + "-" + Long.toString(version);
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID = strSID + "-" + Long.toString(authority);
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID = strSID + "-" + Long.toString(rid);
            ++j;
        }
        return strSID;
    }
}

