/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.hipchat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpMethod;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.http.Scheme;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.hipchat.HipChatAccount;
import org.elasticsearch.xpack.notification.hipchat.HipChatMessage;
import org.elasticsearch.xpack.notification.hipchat.HipChatServer;
import org.elasticsearch.xpack.notification.hipchat.SentMessages;

public class UserAccount
extends HipChatAccount {
    public static final String TYPE = "user";
    final Defaults defaults;

    public UserAccount(String name, Settings settings, HipChatServer defaultServer, HttpClient httpClient, Logger logger) {
        super(name, HipChatAccount.Profile.USER, settings, defaultServer, httpClient, logger);
        this.defaults = new Defaults(settings);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void validateParsedTemplate(String watchId, String actionId, HipChatMessage.Template template) throws SettingsException {
        if (template.from != null) {
            throw new ElasticsearchParseException("invalid [hipchat] action for [" + watchId + "/" + actionId + "]. [" + this.name + "] hipchat account doesn't support custom `from` fields", new Object[0]);
        }
    }

    @Override
    public HipChatMessage render(String watchId, String actionId, TextTemplateEngine engine, HipChatMessage.Template template, Map<String, Object> model) {
        String[] rooms = this.defaults.rooms;
        if (template.rooms != null) {
            rooms = new String[template.rooms.length];
            for (int i = 0; i < template.rooms.length; ++i) {
                rooms[i] = engine.render(template.rooms[i], model);
            }
        }
        String[] users = this.defaults.users;
        if (template.users != null) {
            users = new String[template.users.length];
            for (int i = 0; i < template.users.length; ++i) {
                users[i] = engine.render(template.users[i], model);
            }
        }
        String message = engine.render(template.body, model);
        HipChatMessage.Color color = HipChatMessage.Color.resolve(engine.render(template.color, model), this.defaults.color);
        Boolean notify = template.notify != null ? template.notify : this.defaults.notify;
        HipChatMessage.Format messageFormat = template.format != null ? template.format : this.defaults.format;
        return new HipChatMessage(message, rooms, users, null, messageFormat, color, notify);
    }

    @Override
    public SentMessages send(HipChatMessage message, HttpProxy proxy) {
        HttpResponse response;
        HttpRequest request;
        ArrayList<SentMessages.SentMessage> sentMessages = new ArrayList<SentMessages.SentMessage>();
        if (message.rooms != null) {
            for (String room : message.rooms) {
                request = this.buildRoomRequest(room, message, proxy);
                try {
                    response = this.httpClient.execute(request);
                    sentMessages.add(SentMessages.SentMessage.responded(room, SentMessages.SentMessage.TargetType.ROOM, message, request, response));
                }
                catch (IOException e) {
                    this.logger.error("failed to execute hipchat api http request", (Throwable)e);
                    sentMessages.add(SentMessages.SentMessage.error(room, SentMessages.SentMessage.TargetType.ROOM, message, ExceptionsHelper.detailedMessage(e)));
                }
            }
        }
        if (message.users != null) {
            for (String user : message.users) {
                request = this.buildUserRequest(user, message, proxy);
                try {
                    response = this.httpClient.execute(request);
                    sentMessages.add(SentMessages.SentMessage.responded(user, SentMessages.SentMessage.TargetType.USER, message, request, response));
                }
                catch (Exception e) {
                    this.logger.error("failed to execute hipchat api http request", (Throwable)e);
                    sentMessages.add(SentMessages.SentMessage.error(user, SentMessages.SentMessage.TargetType.USER, message, ExceptionsHelper.detailedMessage(e)));
                }
            }
        }
        return new SentMessages(this.name, sentMessages);
    }

    public HttpRequest buildRoomRequest(String room, final HipChatMessage message, HttpProxy proxy) {
        HttpRequest.Builder builder = this.server.httpRequest().method(HttpMethod.POST).scheme(Scheme.HTTPS).path("/v2/room/" + room + "/notification").setHeader("Content-Type", "application/json").setHeader("Authorization", "Bearer " + this.authToken).body(XContentHelper.toString(new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder xbuilder, ToXContent.Params params) throws IOException {
                xbuilder.field("message", message.body);
                if (message.format != null) {
                    xbuilder.field("message_format", message.format.value());
                }
                if (message.notify != null) {
                    xbuilder.field("notify", message.notify);
                }
                if (message.color != null) {
                    xbuilder.field("color", String.valueOf(message.color.value()));
                }
                return xbuilder;
            }
        }));
        if (proxy != null) {
            builder.proxy(proxy);
        }
        return builder.build();
    }

    public HttpRequest buildUserRequest(String user, final HipChatMessage message, HttpProxy proxy) {
        HttpRequest.Builder builder = this.server.httpRequest().method(HttpMethod.POST).scheme(Scheme.HTTPS).path("/v2/user/" + user + "/message").setHeader("Content-Type", "application/json").setHeader("Authorization", "Bearer " + this.authToken).body(XContentHelper.toString(new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder xbuilder, ToXContent.Params params) throws IOException {
                xbuilder.field("message", message.body);
                if (message.format != null) {
                    xbuilder.field("message_format", message.format.value());
                }
                if (message.notify != null) {
                    xbuilder.field("notify", message.notify);
                }
                return xbuilder;
            }
        }));
        if (proxy != null) {
            builder.proxy(proxy);
        }
        return builder.build();
    }

    static class Defaults {
        @Nullable
        final String[] rooms;
        @Nullable
        final String[] users;
        @Nullable
        final HipChatMessage.Format format;
        @Nullable
        final HipChatMessage.Color color;
        @Nullable
        final Boolean notify;

        Defaults(Settings settings) {
            this.rooms = settings.getAsArray(HipChatAccount.DEFAULT_ROOM_SETTING, null);
            this.users = settings.getAsArray(HipChatAccount.DEFAULT_USER_SETTING, null);
            this.format = HipChatMessage.Format.resolve(settings, HipChatAccount.DEFAULT_FORMAT_SETTING, null);
            this.color = HipChatMessage.Color.resolve(settings, HipChatAccount.DEFAULT_COLOR_SETTING, null);
            this.notify = settings.getAsBoolean(HipChatAccount.DEFAULT_NOTIFY_SETTING, null);
        }
    }
}

