/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.resolver.shards;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardMonitoringDoc;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;

public class ShardsResolver
extends MonitoringIndexNameResolver.Timestamped<ShardMonitoringDoc> {
    public static final String TYPE = "shards";
    static final Set<String> FILTERS;

    public ShardsResolver(MonitoredSystem id, Settings settings) {
        super(id, settings);
    }

    @Override
    public String type(ShardMonitoringDoc document) {
        return TYPE;
    }

    @Override
    public String id(ShardMonitoringDoc document) {
        return ShardsResolver.id(document.getClusterStateUUID(), document.getShardRouting());
    }

    @Override
    public Set<String> filters() {
        return FILTERS;
    }

    @Override
    protected void buildXContent(ShardMonitoringDoc document, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("state_uuid", document.getClusterStateUUID());
        ShardRouting shardRouting = document.getShardRouting();
        if (shardRouting != null) {
            builder.field("shard", shardRouting, params);
        }
    }

    static String id(String stateUUID, ShardRouting shardRouting) {
        StringBuilder builder = new StringBuilder();
        builder.append(stateUUID);
        builder.append(':');
        if (shardRouting.assignedToNode()) {
            builder.append(shardRouting.currentNodeId());
        } else {
            builder.append("_na");
        }
        builder.append(':');
        builder.append(shardRouting.getIndexName());
        builder.append(':');
        builder.append((Object)shardRouting.id());
        builder.append(':');
        if (shardRouting.primary()) {
            builder.append("p");
        } else {
            builder.append("r");
        }
        return builder.toString();
    }

    static {
        HashSet<String> filters = Sets.newHashSet("cluster_uuid", "timestamp", "source_node", "state_uuid", "shard.state", "shard.primary", "shard.node", "shard.relocating_node", "shard.shard", "shard.index");
        FILTERS = Collections.unmodifiableSet(filters);
    }

    static final class Fields {
        static final String SHARD = "shard";
        static final String STATE_UUID = "state_uuid";

        Fields() {
        }
    }
}

