/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Collections;
import java.util.Objects;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class DataTypeMappingHttpResource
extends PublishableHttpResource {
    private static final Logger logger = Loggers.getLogger(DataTypeMappingHttpResource.class);
    private final String typeName;

    public DataTypeMappingHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, String typeName) {
        super(resourceOwnerName, masterTimeout, Collections.emptyMap());
        this.typeName = Objects.requireNonNull(typeName);
    }

    @Override
    protected PublishableHttpResource.CheckResponse doCheck(RestClient client) {
        Tuple<PublishableHttpResource.CheckResponse, Response> resource = this.checkForResource(client, logger, "/.monitoring-data-2/_mapping", this.typeName, "monitoring mapping type", this.resourceOwnerName, "monitoring cluster");
        PublishableHttpResource.CheckResponse checkResponse = resource.v1();
        if (checkResponse == PublishableHttpResource.CheckResponse.EXISTS && resource.v2().getEntity().getContentLength() <= 2L) {
            checkResponse = PublishableHttpResource.CheckResponse.DOES_NOT_EXIST;
        } else if (checkResponse == PublishableHttpResource.CheckResponse.DOES_NOT_EXIST) {
            checkResponse = PublishableHttpResource.CheckResponse.EXISTS;
        }
        return checkResponse;
    }

    @Override
    protected boolean doPublish(RestClient client) {
        StringEntity disabledEntity = new StringEntity("{\"enabled\":false}", ContentType.APPLICATION_JSON);
        return this.putResource(client, logger, "/.monitoring-data-2/_mapping", this.typeName, () -> disabledEntity, "monitoring mapping type", this.resourceOwnerName, "monitoring cluster");
    }
}

