/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MonitoringDoc
implements Writeable {
    private final String monitoringId;
    private final String monitoringVersion;
    private String clusterUUID;
    private long timestamp;
    private Node sourceNode;

    public MonitoringDoc(String monitoringId, String monitoringVersion) {
        this.monitoringId = monitoringId;
        this.monitoringVersion = monitoringVersion;
    }

    public MonitoringDoc(StreamInput in) throws IOException {
        this(in.readOptionalString(), in.readOptionalString());
        this.clusterUUID = in.readOptionalString();
        this.timestamp = in.readVLong();
        this.sourceNode = in.readOptionalWriteable(Node::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMonitoringId());
        out.writeOptionalString(this.getMonitoringVersion());
        out.writeOptionalString(this.getClusterUUID());
        out.writeVLong(this.getTimestamp());
        out.writeOptionalWriteable(this.getSourceNode());
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public void setClusterUUID(String clusterUUID) {
        this.clusterUUID = clusterUUID;
    }

    public String getMonitoringId() {
        return this.monitoringId;
    }

    public String getMonitoringVersion() {
        return this.monitoringVersion;
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(Node node) {
        this.sourceNode = node;
    }

    public void setSourceNode(DiscoveryNode node) {
        this.setSourceNode(new Node(node.getId(), node.getHostName(), node.getAddress().toString(), node.getHostAddress(), node.getName(), node.getAttributes()));
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return "monitoring document [class=" + this.getClass().getSimpleName() + ", monitoring id=" + this.getMonitoringId() + ", monitoring version=" + this.getMonitoringVersion() + "]";
    }

    public static class Node
    implements Writeable,
    ToXContent {
        private String uuid;
        private String host;
        private String transportAddress;
        private String ip;
        private String name;
        private Map<String, String> attributes;

        public Node(String uuid, String host, String transportAddress, String ip, String name, Map<String, String> attributes) {
            this.uuid = uuid;
            this.host = host;
            this.transportAddress = transportAddress;
            this.ip = ip;
            this.name = name;
            this.attributes = attributes == null ? new HashMap<String, String>() : Collections.unmodifiableMap(attributes);
        }

        public Node(StreamInput in) throws IOException {
            this.uuid = in.readOptionalString();
            this.host = in.readOptionalString();
            this.transportAddress = in.readOptionalString();
            this.ip = in.readOptionalString();
            this.name = in.readOptionalString();
            int size = in.readVInt();
            this.attributes = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                this.attributes.put(in.readString(), in.readString());
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.uuid);
            out.writeOptionalString(this.host);
            out.writeOptionalString(this.transportAddress);
            out.writeOptionalString(this.ip);
            out.writeOptionalString(this.name);
            if (this.attributes != null) {
                out.writeVInt(this.attributes.size());
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    out.writeString(entry.getKey());
                    out.writeString(entry.getValue());
                }
            } else {
                out.writeVInt(0);
            }
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getHost() {
            return this.host;
        }

        public String getTransportAddress() {
            return this.transportAddress;
        }

        public String getIp() {
            return this.ip;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("uuid", this.getUUID());
            builder.field("host", this.getHost());
            builder.field("transport_address", this.getTransportAddress());
            builder.field("ip", this.getIp());
            builder.field("name", this.getName());
            builder.startObject("attributes");
            for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            builder.endObject();
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (this.uuid != null ? !this.uuid.equals(node.uuid) : node.uuid != null) {
                return false;
            }
            if (this.host != null ? !this.host.equals(node.host) : node.host != null) {
                return false;
            }
            if (this.transportAddress != null ? !this.transportAddress.equals(node.transportAddress) : node.transportAddress != null) {
                return false;
            }
            if (this.ip != null ? !this.ip.equals(node.ip) : node.ip != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(node.name) : node.name != null) {
                return false;
            }
            return !(this.attributes == null ? node.attributes != null : !this.attributes.equals(node.attributes));
        }

        public int hashCode() {
            int result = this.uuid != null ? this.uuid.hashCode() : 0;
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + (this.transportAddress != null ? this.transportAddress.hashCode() : 0);
            result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            return result;
        }

        static final class Fields {
            static final String UUID = "uuid";
            static final String HOST = "host";
            static final String TRANSPORT_ADDRESS = "transport_address";
            static final String IP = "ip";
            static final String NAME = "name";
            static final String ATTRIBUTES = "attributes";

            Fields() {
            }
        }
    }
}

