/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class Exporters
extends AbstractLifecycleComponent
implements Iterable<Exporter> {
    private final Map<String, Exporter.Factory> factories;
    private final AtomicReference<Map<String, Exporter>> exporters;
    private final ThreadContext threadContext;

    public Exporters(Settings settings, Map<String, Exporter.Factory> factories, ClusterService clusterService, ThreadContext threadContext) {
        super(settings);
        this.factories = factories;
        this.exporters = new AtomicReference(Collections.emptyMap());
        this.threadContext = Objects.requireNonNull(threadContext);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MonitoringSettings.EXPORTERS_SETTINGS, this::setExportersSetting);
    }

    private void setExportersSetting(Settings exportersSetting) {
        if (this.lifecycleState() == Lifecycle.State.STARTED) {
            if (exportersSetting.names().isEmpty()) {
                return;
            }
            Map<String, Exporter> updated = this.initExporters(exportersSetting);
            Exporters.closeExporters(this.logger, this.exporters.getAndSet(updated));
        }
    }

    @Override
    protected void doStart() {
        this.exporters.set(this.initExporters(MonitoringSettings.EXPORTERS_SETTINGS.get(this.settings)));
    }

    @Override
    protected void doStop() {
        Exporters.closeExporters(this.logger, this.exporters.get());
    }

    @Override
    protected void doClose() {
    }

    public Exporter getExporter(String name) {
        return this.exporters.get().get(name);
    }

    @Override
    public Iterator<Exporter> iterator() {
        return this.exporters.get().values().iterator();
    }

    static void closeExporters(Logger logger, Map<String, Exporter> exporters) {
        for (Exporter exporter : exporters.values()) {
            try {
                exporter.close();
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("failed to close exporter [{}]", (Object)exporter.name()), (Throwable)e);
            }
        }
    }

    ExportBulk openBulk() {
        ArrayList<ExportBulk> bulks = new ArrayList<ExportBulk>();
        for (Exporter exporter : this) {
            try {
                ExportBulk bulk = exporter.openBulk();
                if (bulk == null) {
                    this.logger.debug("skipping exporter [{}] as it is not ready yet", (Object)exporter.name());
                    continue;
                }
                bulks.add(bulk);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exporter [{}] failed to open exporting bulk", (Object)exporter.name()), (Throwable)e);
            }
        }
        return bulks.isEmpty() ? null : new ExportBulk.Compound(bulks, this.threadContext);
    }

    Map<String, Exporter> initExporters(Settings settings) {
        HashSet<String> singletons = new HashSet<String>();
        HashMap<String, Exporter> exporters = new HashMap<String, Exporter>();
        boolean hasDisabled = false;
        for (String name : settings.names()) {
            Settings exporterSettings = settings.getAsSettings(name);
            String type = exporterSettings.get("type");
            if (type == null) {
                throw new SettingsException("missing exporter type for [" + name + "] exporter");
            }
            Exporter.Factory factory = this.factories.get(type);
            if (factory == null) {
                throw new SettingsException("unknown exporter type [" + type + "] set for exporter [" + name + "]");
            }
            Exporter.Config config = new Exporter.Config(name, type, exporterSettings);
            if (!config.enabled()) {
                hasDisabled = true;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("exporter [{}/{}] is disabled", (Object)type, (Object)name);
                continue;
            }
            Exporter exporter = factory.create(config);
            if (exporter.isSingleton()) {
                if (singletons.contains(type)) {
                    throw new SettingsException("multiple [" + type + "] exporters are configured. there can only be one [" + type + "] exporter configured");
                }
                singletons.add(type);
            }
            exporters.put(config.name(), exporter);
        }
        if (exporters.isEmpty() && !hasDisabled) {
            Exporter.Config config = new Exporter.Config("default_local", "local", Settings.EMPTY);
            exporters.put(config.name(), this.factories.get("local").create(config));
        }
        return exporters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Collection<MonitoringDoc> docs, ActionListener<Void> listener) throws ExportException {
        block4: {
            block6: {
                block7: {
                    block5: {
                        if (this.lifecycleState() == Lifecycle.State.STARTED) break block5;
                        listener.onFailure(new ExportException("Export service is not started", new Object[0]));
                        break block4;
                    }
                    if (docs == null || docs.size() <= 0) break block6;
                    ExportBulk bulk = this.openBulk();
                    if (bulk == null) break block7;
                    AtomicReference<ExportException> exceptionRef = new AtomicReference<ExportException>();
                    try {
                        bulk.add(docs);
                    }
                    catch (ExportException e) {
                        try {
                            exceptionRef.set(e);
                        }
                        catch (Throwable throwable) {
                            bulk.close(this.lifecycleState() == Lifecycle.State.STARTED, ActionListener.wrap(r -> {
                                if (exceptionRef.get() == null) {
                                    listener.onResponse(null);
                                } else {
                                    listener.onFailure((Exception)exceptionRef.get());
                                }
                            }, listener::onFailure));
                            throw throwable;
                        }
                        bulk.close(this.lifecycleState() == Lifecycle.State.STARTED, ActionListener.wrap(r -> {
                            if (exceptionRef.get() == null) {
                                listener.onResponse(null);
                            } else {
                                listener.onFailure((Exception)exceptionRef.get());
                            }
                        }, listener::onFailure));
                        break block4;
                    }
                    bulk.close(this.lifecycleState() == Lifecycle.State.STARTED, ActionListener.wrap(r -> {
                        if (exceptionRef.get() == null) {
                            listener.onResponse(null);
                        } else {
                            listener.onFailure((Exception)exceptionRef.get());
                        }
                    }, listener::onFailure));
                    break block4;
                }
                listener.onResponse(null);
                break block4;
            }
            listener.onResponse(null);
        }
    }
}

