/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.graph.action.VertexRequest;

public class Hop {
    final Hop parentHop;
    List<VertexRequest> vertices = null;
    QueryBuilder guidingQuery = null;

    Hop(Hop parent) {
        this.parentHop = parent;
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.getEffectiveVertexRequests().size() == 0) {
            validationException = ValidateActions.addValidationError("Graph explore hop must have at least one VertexRequest", validationException);
        }
        return validationException;
    }

    public Hop getParentHop() {
        return this.parentHop;
    }

    void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalNamedWriteable(this.guidingQuery);
        if (this.vertices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.vertices.size());
            for (VertexRequest vr : this.vertices) {
                vr.writeTo(out);
            }
        }
    }

    void readFrom(StreamInput in) throws IOException {
        this.guidingQuery = in.readOptionalNamedWriteable(QueryBuilder.class);
        int size = in.readVInt();
        if (size > 0) {
            this.vertices = new ArrayList<VertexRequest>();
            for (int i = 0; i < size; ++i) {
                VertexRequest vr = new VertexRequest();
                vr.readFrom(in);
                this.vertices.add(vr);
            }
        }
    }

    public QueryBuilder guidingQuery() {
        if (this.guidingQuery != null) {
            return this.guidingQuery;
        }
        return QueryBuilders.matchAllQuery();
    }

    public VertexRequest addVertexRequest(String fieldName) {
        if (this.vertices == null) {
            this.vertices = new ArrayList<VertexRequest>();
        }
        VertexRequest vr = new VertexRequest();
        vr.fieldName(fieldName);
        this.vertices.add(vr);
        return vr;
    }

    public void guidingQuery(QueryBuilder queryBuilder) {
        this.guidingQuery = queryBuilder;
    }

    protected List<VertexRequest> getEffectiveVertexRequests() {
        if (this.vertices != null) {
            return this.vertices;
        }
        if (this.parentHop == null) {
            return Collections.emptyList();
        }
        return this.parentHop.getEffectiveVertexRequests();
    }

    int getNumberVertexRequests() {
        return this.getEffectiveVertexRequests().size();
    }

    VertexRequest getVertexRequest(int requestNumber) {
        return this.getEffectiveVertexRequests().get(requestNumber);
    }
}

