/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.extensions;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.extensions.XPackExtension;
import org.elasticsearch.xpack.extensions.XPackExtensionInfo;
import org.elasticsearch.xpack.extensions.XPackExtensionSecurity;

public class XPackExtensionsService {
    private final Settings settings;
    private final List<Tuple<XPackExtensionInfo, XPackExtension>> extensions;

    public XPackExtensionsService(Settings settings, Path extsDirectory, Collection<Class<? extends XPackExtension>> classpathExtensions) {
        try {
            XPackExtensionSecurity.configure(extsDirectory);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to configure extension policy", e);
        }
        this.settings = settings;
        ArrayList<Tuple<XPackExtensionInfo, XPackExtension>> extensionsLoaded = new ArrayList<Tuple<XPackExtensionInfo, XPackExtension>>();
        for (Class<? extends XPackExtension> extClass : classpathExtensions) {
            XPackExtension ext = this.loadExtension(extClass, settings);
            XPackExtensionInfo extInfo = new XPackExtensionInfo(ext.name(), ext.description(), "NA", extClass.getName());
            extensionsLoaded.add(new Tuple<XPackExtensionInfo, XPackExtension>(extInfo, ext));
        }
        if (extsDirectory != null) {
            try {
                List<Bundle> bundles = XPackExtensionsService.getExtensionBundles(extsDirectory);
                List<Tuple<XPackExtensionInfo, XPackExtension>> loaded = this.loadBundles(bundles);
                extensionsLoaded.addAll(loaded);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize extensions", ex);
            }
        }
        this.extensions = Collections.unmodifiableList(extensionsLoaded);
    }

    public List<XPackExtension> getExtensions() {
        return this.extensions.stream().map(Tuple::v2).collect(Collectors.toList());
    }

    static List<Bundle> getExtensionBundles(Path extsDirectory) throws IOException {
        Logger logger = Loggers.getLogger(XPackExtensionsService.class);
        if (!FileSystemUtils.isAccessibleDirectory(extsDirectory, logger)) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(extsDirectory);){
            for (Path extension : stream) {
                XPackExtensionInfo info;
                if (FileSystemUtils.isHidden(extension)) {
                    logger.trace("--- skip hidden extension file[{}]", (Object)extension.toAbsolutePath());
                    continue;
                }
                logger.trace("--- adding extension [{}]", (Object)extension.toAbsolutePath());
                try {
                    info = XPackExtensionInfo.readFromProperties(extension);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not load extension descriptor for existing extension [" + extension.getFileName() + "]. Was the extension built before 2.0?", e);
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(extension, "*.jar");){
                    for (Path jar : jarStream) {
                        urls.add(jar.toRealPath(new LinkOption[0]).toUri().toURL());
                    }
                }
                Bundle bundle = new Bundle();
                bundles.add(bundle);
                bundle.info = info;
                bundle.urls.addAll(urls);
            }
        }
        return bundles;
    }

    private List<Tuple<XPackExtensionInfo, XPackExtension>> loadBundles(List<Bundle> bundles) {
        ArrayList<Tuple<XPackExtensionInfo, XPackExtension>> exts = new ArrayList<Tuple<XPackExtensionInfo, XPackExtension>>();
        for (Bundle bundle : bundles) {
            try {
                ArrayList<URL> jars = new ArrayList<URL>();
                jars.addAll(Arrays.asList(JarHell.parseClassPath()));
                ClassLoader xpackLoader = this.getClass().getClassLoader();
                if (xpackLoader instanceof URLClassLoader) {
                    jars.addAll(Arrays.asList(((URLClassLoader)xpackLoader).getURLs()));
                }
                jars.addAll(bundle.urls);
                JarHell.checkJarHell(jars.toArray(new URL[0]));
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to load bundle " + bundle.urls + " due to jar hell", e);
            }
            URLClassLoader loader = URLClassLoader.newInstance(bundle.urls.toArray(new URL[0]), this.getClass().getClassLoader());
            Class<? extends XPackExtension> extClass = this.loadExtensionClass(bundle.info.getClassname(), loader);
            XPackExtension ext = this.loadExtension(extClass, this.settings);
            exts.add(new Tuple<XPackExtensionInfo, XPackExtension>(bundle.info, ext));
        }
        return Collections.unmodifiableList(exts);
    }

    private Class<? extends XPackExtension> loadExtensionClass(String className, ClassLoader loader) {
        try {
            return loader.loadClass(className).asSubclass(XPackExtension.class);
        }
        catch (ClassNotFoundException e) {
            throw new ElasticsearchException("Could not find extension class [" + className + "]", (Throwable)e, new Object[0]);
        }
    }

    private XPackExtension loadExtension(Class<? extends XPackExtension> extClass, Settings settings) {
        try {
            try {
                return extClass.getConstructor(Settings.class).newInstance(settings);
            }
            catch (NoSuchMethodException e) {
                try {
                    return extClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw new ElasticsearchException("No constructor for [" + extClass + "]. An extension class must have either an empty default constructor or a single argument constructor accepting a Settings instance", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to load extension class [" + extClass.getName() + "]", (Throwable)e, new Object[0]);
        }
    }

    static class Bundle {
        XPackExtensionInfo info;
        List<URL> urls = new ArrayList<URL>();

        Bundle() {
        }
    }
}

