/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;

public class XContentUtils {
    private XContentUtils() {
    }

    public static void verifyObject(XContentParser parser) throws IOException, ElasticsearchParseException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return;
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("expected an object, but found token [{}]", new Object[]{parser.currentToken()});
        }
    }

    public static String[] readStringArray(XContentParser parser, boolean allowNull) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            if (allowNull) {
                return null;
            }
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but found null value instead", parser.currentName());
        }
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but found [{}] value instead", new Object[]{parser.currentName(), parser.currentToken()});
        }
        ArrayList<String> list = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.VALUE_STRING) {
                list.add(parser.text());
                continue;
            }
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but one of the value in the array is [{}]", new Object[]{parser.currentName(), token});
        }
        return list.toArray(new String[list.size()]);
    }

    public static List<Object> readList(XContentParser parser, XContentParser.Token token) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            list.add(XContentUtils.readValue(parser, token));
        }
        return list;
    }

    public static Object readValue(XContentParser parser, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = parser.numberType();
            if (numberType == XContentParser.NumberType.INT) {
                return parser.intValue();
            }
            if (numberType == XContentParser.NumberType.LONG) {
                return parser.longValue();
            }
            if (numberType == XContentParser.NumberType.FLOAT) {
                return Float.valueOf(parser.floatValue());
            }
            if (numberType == XContentParser.NumberType.DOUBLE) {
                return parser.doubleValue();
            }
        } else {
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                return parser.booleanValue();
            }
            if (token == XContentParser.Token.START_OBJECT) {
                return parser.map();
            }
            if (token == XContentParser.Token.START_ARRAY) {
                return XContentUtils.readList(parser, token);
            }
            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                return parser.binaryValue();
            }
        }
        return null;
    }
}

