/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class HttpProxy
implements ToXContent,
Streamable {
    public static final HttpProxy NO_PROXY = new HttpProxy(null, null);
    private String host;
    private Integer port;

    public HttpProxy(String host, Integer port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.host = in.readOptionalString();
        this.port = in.readOptionalVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.host);
        out.writeOptionalVInt(this.port);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (Strings.hasText(this.host) && this.port != null) {
            builder.startObject("proxy").field("host", this.host).field("port", this.port).endObject();
        }
        return builder;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Proxy proxy() throws UnknownHostException {
        if (Strings.hasText(this.host) && this.port != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(InetAddress.getByName(this.host), (int)this.port));
        }
        return Proxy.NO_PROXY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpProxy that = (HttpProxy)o;
        return Objects.equals(this.port, that.port) && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public static HttpProxy parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String host = null;
        Integer port = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.HOST.match(currentFieldName)) {
                host = parser.text();
                continue;
            }
            if (!Field.PORT.match(currentFieldName) || (port = Integer.valueOf(parser.intValue())) > 0 && port < 65535) continue;
            throw new ElasticsearchParseException("Proxy port must be between 1 and 65534, but was " + port, new Object[0]);
        }
        if (port == null || host == null) {
            throw new ElasticsearchParseException("Proxy must contain 'port' and 'host' field", new Object[0]);
        }
        return new HttpProxy(host, port);
    }

    public static interface Field {
        public static final ParseField HOST = new ParseField("host", new String[0]);
        public static final ParseField PORT = new ParseField("port", new String[0]);
    }
}

