/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface XPackFeatureSet {
    public String name();

    public String description();

    public boolean available();

    public boolean enabled();

    public void usage(ActionListener<Usage> var1);

    public static abstract class Usage
    implements ToXContentObject,
    NamedWriteable {
        private static final String AVAILABLE_XFIELD = "available";
        private static final String ENABLED_XFIELD = "enabled";
        protected final String name;
        protected final boolean available;
        protected final boolean enabled;

        public Usage(StreamInput input) throws IOException {
            this(input.readString(), input.readBoolean(), input.readBoolean());
        }

        public Usage(String name, boolean available, boolean enabled) {
            this.name = name;
            this.available = available;
            this.enabled = enabled;
        }

        public String name() {
            return this.name;
        }

        public boolean available() {
            return this.available;
        }

        public boolean enabled() {
            return this.enabled;
        }

        @Override
        public String getWriteableName() {
            return this.name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeBoolean(this.available);
            out.writeBoolean(this.enabled);
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerXContent(builder, params);
            return builder.endObject();
        }

        protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(AVAILABLE_XFIELD, this.available);
            builder.field(ENABLED_XFIELD, this.enabled);
        }
    }
}

