/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import org.elasticsearch.jboss.netty.buffer.ChannelBuffer;
import org.elasticsearch.jboss.netty.channel.Channel;
import org.elasticsearch.jboss.netty.channel.ChannelHandlerContext;
import org.elasticsearch.jboss.netty.handler.codec.frame.FrameDecoder;
import org.elasticsearch.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.netty3.Netty3Utils;

final class Netty3SizeHeaderFrameDecoder
extends FrameDecoder {
    Netty3SizeHeaderFrameDecoder() {
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        try {
            boolean continueProcessing = TcpTransport.validateMessageHeader(Netty3Utils.toBytesReference(buffer));
            buffer.skipBytes(6);
            return continueProcessing ? buffer : null;
        }
        catch (IllegalArgumentException ex) {
            throw new TooLongFrameException(ex.getMessage(), ex);
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }
}

