/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportMessage;

public abstract class TransportRequest
extends TransportMessage {
    private TaskId parentTaskId = TaskId.EMPTY_TASK_ID;

    public void setParentTask(String parentTaskNode, long parentTaskId) {
        this.setParentTask(new TaskId(parentTaskNode, parentTaskId));
    }

    public void setParentTask(TaskId taskId) {
        this.parentTaskId = taskId;
    }

    public TaskId getParentTask() {
        return this.parentTaskId;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId) {
        return new Task(id, type, action, this.getDescription(), parentTaskId);
    }

    public String getDescription() {
        return "";
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.parentTaskId = TaskId.readFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.parentTaskId.writeTo(out);
    }

    public static class Empty
    extends TransportRequest {
        public static final Empty INSTANCE = new Empty();
    }
}

