/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.collapse;

import java.io.IOException;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.InnerHitBuilder;

public class CollapseContext {
    private final MappedFieldType fieldType;
    private final InnerHitBuilder innerHit;

    public CollapseContext(MappedFieldType fieldType, InnerHitBuilder innerHit) {
        this.fieldType = fieldType;
        this.innerHit = innerHit;
    }

    public MappedFieldType getFieldType() {
        return this.fieldType;
    }

    public InnerHitBuilder getInnerHit() {
        return this.innerHit;
    }

    public CollapsingTopDocsCollector<?> createTopDocs(Sort sort, int topN, boolean trackMaxScore) throws IOException {
        if (this.fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
            return CollapsingTopDocsCollector.createKeyword(this.fieldType.name(), sort, topN, trackMaxScore);
        }
        if (this.fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return CollapsingTopDocsCollector.createNumeric(this.fieldType.name(), sort, topN, trackMaxScore);
        }
        throw new IllegalStateException("unknown type for collapse field " + this.fieldType.name() + ", only keywords and numbers are accepted");
    }
}

