/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;
import org.elasticsearch.index.fielddata.SortingNumericDocValues;
import org.elasticsearch.index.fielddata.SortingNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.values.ScriptBytesValues;
import org.elasticsearch.search.aggregations.support.values.ScriptDoubleValues;
import org.elasticsearch.search.aggregations.support.values.ScriptLongValues;

public abstract class ValuesSource {
    public abstract SortedBinaryDocValues bytesValues(LeafReaderContext var1) throws IOException;

    public abstract Bits docsWithValue(LeafReaderContext var1) throws IOException;

    public boolean needsScores() {
        return false;
    }

    public static abstract class GeoPoint
    extends ValuesSource {
        public static final GeoPoint EMPTY = new GeoPoint(){

            @Override
            public MultiGeoPointValues geoPointValues(LeafReaderContext context) {
                return FieldData.emptyMultiGeoPoints(context.reader().maxDoc());
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return FieldData.emptySortedBinary(context.reader().maxDoc());
            }
        };

        @Override
        public Bits docsWithValue(LeafReaderContext context) {
            MultiGeoPointValues geoPoints = this.geoPointValues(context);
            if (FieldData.unwrapSingleton(geoPoints) != null) {
                return FieldData.unwrapSingletonBits(geoPoints);
            }
            return FieldData.docsWithValue(geoPoints, context.reader().maxDoc());
        }

        public abstract MultiGeoPointValues geoPointValues(LeafReaderContext var1);

        public static class Fielddata
        extends GeoPoint {
            protected final IndexGeoPointFieldData indexFieldData;

            public Fielddata(IndexGeoPointFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            @Override
            public MultiGeoPointValues geoPointValues(LeafReaderContext context) {
                return ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
            }
        }
    }

    public static class WithScript
    extends Bytes {
        private final ValuesSource delegate;
        private final SearchScript script;

        public WithScript(ValuesSource delegate, SearchScript script) {
            this.delegate = delegate;
            this.script = script;
        }

        @Override
        public boolean needsScores() {
            return this.script.needsScores();
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return new BytesValues(this.delegate.bytesValues(context), this.script.getLeafSearchScript(context));
        }

        static class BytesValues
        extends SortingBinaryDocValues
        implements ScorerAware {
            private final SortedBinaryDocValues bytesValues;
            private final LeafSearchScript script;

            BytesValues(SortedBinaryDocValues bytesValues, LeafSearchScript script) {
                this.bytesValues = bytesValues;
                this.script = script;
            }

            @Override
            public void setDocument(int docId) {
                this.bytesValues.setDocument(docId);
                this.count = this.bytesValues.count();
                this.grow();
                for (int i = 0; i < this.count; ++i) {
                    BytesRef value = this.bytesValues.valueAt(i);
                    this.script.setNextAggregationValue(value.utf8ToString());
                    this.values[i].copyChars(this.script.run().toString());
                }
                this.sort();
            }

            @Override
            public void setScorer(Scorer scorer) {
                this.script.setScorer(scorer);
            }
        }
    }

    public static abstract class Numeric
    extends ValuesSource {
        public static final Numeric EMPTY = new Numeric(){

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) {
                return DocValues.emptySortedNumeric(context.reader().maxDoc());
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return org.elasticsearch.index.fielddata.FieldData.emptySortedNumericDoubles(context.reader().maxDoc());
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return org.elasticsearch.index.fielddata.FieldData.emptySortedBinary(context.reader().maxDoc());
            }
        };

        public abstract boolean isFloatingPoint();

        public abstract SortedNumericDocValues longValues(LeafReaderContext var1) throws IOException;

        public abstract SortedNumericDoubleValues doubleValues(LeafReaderContext var1) throws IOException;

        @Override
        public Bits docsWithValue(LeafReaderContext context) throws IOException {
            if (this.isFloatingPoint()) {
                SortedNumericDoubleValues values = this.doubleValues(context);
                if (org.elasticsearch.index.fielddata.FieldData.unwrapSingleton(values) != null) {
                    return org.elasticsearch.index.fielddata.FieldData.unwrapSingletonBits(values);
                }
                return org.elasticsearch.index.fielddata.FieldData.docsWithValue(values, context.reader().maxDoc());
            }
            SortedNumericDocValues values = this.longValues(context);
            if (DocValues.unwrapSingleton(values) != null) {
                return DocValues.unwrapSingletonBits(values);
            }
            return DocValues.docsWithValue(values, context.reader().maxDoc());
        }

        public static class Script
        extends Numeric {
            private final SearchScript script;
            private final ValueType scriptValueType;

            public Script(SearchScript script, ValueType scriptValueType) {
                this.script = script;
                this.scriptValueType = scriptValueType;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.scriptValueType != null ? this.scriptValueType.isFloatingPoint() : true;
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
                return new ScriptLongValues(this.script.getLeafSearchScript(context));
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return new ScriptDoubleValues(this.script.getLeafSearchScript(context));
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new ScriptBytesValues(this.script.getLeafSearchScript(context));
            }

            @Override
            public boolean needsScores() {
                return this.script.needsScores();
            }
        }

        public static class FieldData
        extends Numeric {
            protected final IndexNumericFieldData indexFieldData;

            public FieldData(IndexNumericFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.indexFieldData.getNumericType().isFloatingPoint();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((AtomicNumericFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) {
                return ((AtomicNumericFieldData)this.indexFieldData.load(context)).getLongValues();
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) {
                return ((AtomicNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
            }
        }

        public static class WithScript
        extends Numeric {
            private final Numeric delegate;
            private final SearchScript script;

            public WithScript(Numeric delegate, SearchScript script) {
                this.delegate = delegate;
                this.script = script;
            }

            @Override
            public boolean isFloatingPoint() {
                return true;
            }

            @Override
            public boolean needsScores() {
                return this.script.needsScores();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new WithScript.BytesValues(this.delegate.bytesValues(context), this.script.getLeafSearchScript(context));
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
                return new LongValues(this.delegate.longValues(context), this.script.getLeafSearchScript(context));
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return new DoubleValues(this.delegate.doubleValues(context), this.script.getLeafSearchScript(context));
            }

            static class DoubleValues
            extends SortingNumericDoubleValues
            implements ScorerAware {
                private final SortedNumericDoubleValues doubleValues;
                private final LeafSearchScript script;

                DoubleValues(SortedNumericDoubleValues values, LeafSearchScript script) {
                    this.doubleValues = values;
                    this.script = script;
                }

                @Override
                public void setDocument(int doc) {
                    this.doubleValues.setDocument(doc);
                    this.resize(this.doubleValues.count());
                    this.script.setDocument(doc);
                    for (int i = 0; i < this.count(); ++i) {
                        this.script.setNextAggregationValue(this.doubleValues.valueAt(i));
                        this.values[i] = this.script.runAsDouble();
                    }
                    this.sort();
                }

                @Override
                public void setScorer(Scorer scorer) {
                    this.script.setScorer(scorer);
                }
            }

            static class LongValues
            extends SortingNumericDocValues
            implements ScorerAware {
                private final SortedNumericDocValues longValues;
                private final LeafSearchScript script;

                LongValues(SortedNumericDocValues values, LeafSearchScript script) {
                    this.longValues = values;
                    this.script = script;
                }

                @Override
                public void setDocument(int doc) {
                    this.longValues.setDocument(doc);
                    this.resize(this.longValues.count());
                    this.script.setDocument(doc);
                    for (int i = 0; i < this.count(); ++i) {
                        this.script.setNextAggregationValue(this.longValues.valueAt(i));
                        this.values[i] = this.script.runAsLong();
                    }
                    this.sort();
                }

                @Override
                public void setScorer(Scorer scorer) {
                    this.script.setScorer(scorer);
                }
            }
        }
    }

    public static abstract class Bytes
    extends ValuesSource {
        @Override
        public Bits docsWithValue(LeafReaderContext context) throws IOException {
            SortedBinaryDocValues bytes = this.bytesValues(context);
            if (org.elasticsearch.index.fielddata.FieldData.unwrapSingleton(bytes) != null) {
                return org.elasticsearch.index.fielddata.FieldData.unwrapSingletonBits(bytes);
            }
            return org.elasticsearch.index.fielddata.FieldData.docsWithValue(bytes, context.reader().maxDoc());
        }

        public static class Script
        extends Bytes {
            private final SearchScript script;

            public Script(SearchScript script) {
                this.script = script;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new ScriptBytesValues(this.script.getLeafSearchScript(context));
            }

            @Override
            public boolean needsScores() {
                return this.script.needsScores();
            }
        }

        public static class FieldData
        extends Bytes {
            protected final IndexFieldData<?> indexFieldData;

            public FieldData(IndexFieldData<?> indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return this.indexFieldData.load(context).getBytesValues();
            }
        }

        public static class ParentChild
        extends Bytes {
            protected final ParentChildIndexFieldData indexFieldData;

            public ParentChild(ParentChildIndexFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            public long globalMaxOrd(IndexSearcher indexSearcher, String type) {
                DirectoryReader indexReader = (DirectoryReader)indexSearcher.getIndexReader();
                if (indexReader.leaves().isEmpty()) {
                    return 0L;
                }
                LeafReaderContext atomicReaderContext = indexReader.leaves().get(0);
                IndexParentChildFieldData globalFieldData = this.indexFieldData.loadGlobal(indexReader);
                AtomicParentChildFieldData afd = (AtomicParentChildFieldData)globalFieldData.load(atomicReaderContext);
                SortedDocValues values = afd.getOrdinalsValues(type);
                return values.getValueCount();
            }

            public SortedDocValues globalOrdinalsValues(String type, LeafReaderContext context) {
                IndexParentChildFieldData global = this.indexFieldData.loadGlobal((DirectoryReader)context.parent.reader());
                AtomicParentChildFieldData atomicFieldData = (AtomicParentChildFieldData)global.load(context);
                return atomicFieldData.getOrdinalsValues(type);
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                AtomicParentChildFieldData atomicFieldData = this.indexFieldData.load(context);
                return atomicFieldData.getBytesValues();
            }
        }

        public static abstract class WithOrdinals
        extends Bytes {
            public static final WithOrdinals EMPTY = new WithOrdinals(){

                @Override
                public RandomAccessOrds ordinalsValues(LeafReaderContext context) {
                    return DocValues.emptySortedSet();
                }

                @Override
                public RandomAccessOrds globalOrdinalsValues(LeafReaderContext context) {
                    return DocValues.emptySortedSet();
                }

                @Override
                public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                    return org.elasticsearch.index.fielddata.FieldData.emptySortedBinary(context.reader().maxDoc());
                }
            };

            @Override
            public Bits docsWithValue(LeafReaderContext context) {
                RandomAccessOrds ordinals = this.ordinalsValues(context);
                if (DocValues.unwrapSingleton(ordinals) != null) {
                    return DocValues.docsWithValue(DocValues.unwrapSingleton(ordinals), context.reader().maxDoc());
                }
                return DocValues.docsWithValue(ordinals, context.reader().maxDoc());
            }

            public abstract RandomAccessOrds ordinalsValues(LeafReaderContext var1);

            public abstract RandomAccessOrds globalOrdinalsValues(LeafReaderContext var1);

            public long globalMaxOrd(IndexSearcher indexSearcher) {
                IndexReader indexReader = indexSearcher.getIndexReader();
                if (indexReader.leaves().isEmpty()) {
                    return 0L;
                }
                LeafReaderContext atomicReaderContext = indexReader.leaves().get(0);
                RandomAccessOrds values = this.globalOrdinalsValues(atomicReaderContext);
                return values.getValueCount();
            }

            public static class FieldData
            extends WithOrdinals {
                protected final IndexOrdinalsFieldData indexFieldData;

                public FieldData(IndexOrdinalsFieldData indexFieldData) {
                    this.indexFieldData = indexFieldData;
                }

                @Override
                public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                    AtomicOrdinalsFieldData atomicFieldData = (AtomicOrdinalsFieldData)this.indexFieldData.load(context);
                    return atomicFieldData.getBytesValues();
                }

                @Override
                public RandomAccessOrds ordinalsValues(LeafReaderContext context) {
                    AtomicOrdinalsFieldData atomicFieldData = (AtomicOrdinalsFieldData)this.indexFieldData.load(context);
                    return atomicFieldData.getOrdinalsValues();
                }

                @Override
                public RandomAccessOrds globalOrdinalsValues(LeafReaderContext context) {
                    IndexOrdinalsFieldData global = this.indexFieldData.loadGlobal((DirectoryReader)context.parent.reader());
                    AtomicOrdinalsFieldData atomicFieldData = (AtomicOrdinalsFieldData)global.load(context);
                    return atomicFieldData.getOrdinalsValues();
                }
            }
        }
    }
}

