/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public abstract class InternalAggregation
implements Aggregation,
ToXContent,
NamedWriteable {
    protected final String name;
    protected final Map<String, Object> metaData;
    private final List<PipelineAggregator> pipelineAggregators;

    protected InternalAggregation(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        this.name = name;
        this.pipelineAggregators = pipelineAggregators;
        this.metaData = metaData;
    }

    protected InternalAggregation(StreamInput in) throws IOException {
        this.name = in.readString();
        this.metaData = in.readMap();
        this.pipelineAggregators = in.readNamedWriteableList(PipelineAggregator.class);
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeGenericValue(this.metaData);
        out.writeNamedWriteableList(this.pipelineAggregators);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public String getName() {
        return this.name;
    }

    public final InternalAggregation reduce(List<InternalAggregation> aggregations, ReduceContext reduceContext) {
        InternalAggregation aggResult = this.doReduce(aggregations, reduceContext);
        for (PipelineAggregator pipelineAggregator : this.pipelineAggregators) {
            aggResult = pipelineAggregator.reduce(aggResult, reduceContext);
        }
        return aggResult;
    }

    public abstract InternalAggregation doReduce(List<InternalAggregation> var1, ReduceContext var2);

    @Override
    public Object getProperty(String path) {
        AggregationPath aggPath = AggregationPath.parse(path);
        return this.getProperty(aggPath.getPathElementsAsStringList());
    }

    public abstract Object getProperty(List<String> var1);

    protected static int readSize(StreamInput in) throws IOException {
        int size = in.readVInt();
        return size == 0 ? Integer.MAX_VALUE : size;
    }

    protected static void writeSize(int size, StreamOutput out) throws IOException {
        if (size == Integer.MAX_VALUE) {
            size = 0;
        }
        out.writeVInt(size);
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public List<PipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.metaData != null) {
            builder.field("meta");
            builder.map(this.metaData);
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public static final class CommonFields
    extends ParseField.CommonFields {
        public static final String META = "meta";
        public static final String BUCKETS = "buckets";
        public static final String VALUE = "value";
        public static final String VALUES = "values";
        public static final String VALUE_AS_STRING = "value_as_string";
        public static final String DOC_COUNT = "doc_count";
        public static final String KEY = "key";
        public static final String KEY_AS_STRING = "key_as_string";
        public static final String FROM = "from";
        public static final String FROM_AS_STRING = "from_as_string";
        public static final String TO = "to";
        public static final String TO_AS_STRING = "to_as_string";
    }

    public static class ReduceContext {
        private final BigArrays bigArrays;
        private final ScriptService scriptService;

        public ReduceContext(BigArrays bigArrays, ScriptService scriptService) {
            this.bigArrays = bigArrays;
            this.scriptService = scriptService;
        }

        public BigArrays bigArrays() {
            return this.bigArrays;
        }

        public ScriptService scriptService() {
            return this.scriptService;
        }
    }
}

