/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.license.PutLicenseResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.XPackClient;
import org.elasticsearch.xpack.rest.XPackRestHandler;

public class RestPutLicenseAction
extends XPackRestHandler {
    public RestPutLicenseAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/license", this, RestRequest.Method.POST, "/_license", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/license", this, RestRequest.Method.PUT, "/_license", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_licenses", this, "[POST /_licenses] is deprecated! Use [POST /_xpack/license] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.PUT, "/_licenses", this, "[PUT /_licenses] is deprecated! Use [PUT /_xpack/license] instead.", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        PutLicenseRequest putLicenseRequest = new PutLicenseRequest();
        putLicenseRequest.license(request.content(), request.getXContentType());
        putLicenseRequest.acknowledge(request.paramAsBoolean("acknowledge", false));
        return channel -> client.es().admin().cluster().execute(PutLicenseAction.INSTANCE, putLicenseRequest, new RestBuilderListener<PutLicenseResponse>(channel){

            @Override
            public RestResponse buildResponse(PutLicenseResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

