/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.license.License;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;

public final class OperationModeFileWatcher
implements FileChangesListener {
    private final ResourceWatcherService resourceWatcherService;
    private final Path licenseModePath;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final License.OperationMode defaultOperationMode;
    private volatile License.OperationMode currentOperationMode = this.defaultOperationMode = License.OperationMode.PLATINUM;
    private final Logger logger;
    private final Runnable onChange;

    public OperationModeFileWatcher(ResourceWatcherService resourceWatcherService, Path licenseModePath, Logger logger, Runnable onChange) {
        this.resourceWatcherService = resourceWatcherService;
        this.licenseModePath = licenseModePath;
        this.logger = logger;
        this.onChange = onChange;
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            FileWatcher watcher = new FileWatcher(this.licenseModePath);
            watcher.addListener(this);
            try {
                this.resourceWatcherService.add(watcher, ResourceWatcherService.Frequency.HIGH);
                if (Files.exists(this.licenseModePath, new LinkOption[0])) {
                    this.onChange(this.licenseModePath);
                }
            }
            catch (IOException e) {
                this.logger.error("couldn't initialize watching license mode file", (Throwable)e);
            }
        }
    }

    public License.OperationMode getCurrentOperationMode() {
        return this.currentOperationMode;
    }

    @Override
    public void onFileInit(Path file) {
        this.onChange(file);
    }

    @Override
    public void onFileCreated(Path file) {
        this.onChange(file);
    }

    @Override
    public void onFileDeleted(Path file) {
        this.onChange(file);
    }

    @Override
    public void onFileChanged(Path file) {
        this.onChange(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onChange(Path file) {
        if (file.equals(this.licenseModePath)) {
            block9: {
                License.OperationMode newOperationMode = this.defaultOperationMode;
                try {
                    byte[] content;
                    if (!Files.exists(this.licenseModePath, new LinkOption[0]) || !Files.isReadable(this.licenseModePath)) break block9;
                    try {
                        content = Files.readAllBytes(this.licenseModePath);
                    }
                    catch (IOException e) {
                        this.logger.error(() -> new ParameterizedMessage("couldn't read operation mode from [{}]", (Object)this.licenseModePath.toAbsolutePath()), (Throwable)e);
                        this.currentOperationMode = newOperationMode;
                        return;
                    }
                    String operationMode = new BytesRef(content).utf8ToString();
                    try {
                        newOperationMode = License.OperationMode.resolve(operationMode);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error(() -> new ParameterizedMessage("invalid operation mode in [{}]", (Object)this.licenseModePath.toAbsolutePath()), (Throwable)e);
                        this.currentOperationMode = newOperationMode;
                        return;
                    }
                }
                finally {
                    this.currentOperationMode = newOperationMode;
                }
            }
            this.onChange.run();
        }
    }
}

