/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jboss.netty.channel.socket.oio;

import org.elasticsearch.jboss.netty.channel.AbstractChannelSink;
import org.elasticsearch.jboss.netty.channel.Channel;
import org.elasticsearch.jboss.netty.channel.ChannelEvent;
import org.elasticsearch.jboss.netty.channel.ChannelFuture;
import org.elasticsearch.jboss.netty.channel.ChannelPipeline;
import org.elasticsearch.jboss.netty.channel.socket.ChannelRunnableWrapper;
import org.elasticsearch.jboss.netty.channel.socket.Worker;
import org.elasticsearch.jboss.netty.channel.socket.oio.AbstractOioChannel;
import org.elasticsearch.jboss.netty.channel.socket.oio.AbstractOioWorker;

public abstract class AbstractOioChannelSink
extends AbstractChannelSink {
    public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
        Channel ch = pipeline.getChannel();
        if (ch instanceof AbstractOioChannel) {
            AbstractOioChannel channel = (AbstractOioChannel)ch;
            Worker worker = channel.worker;
            if (worker != null) {
                ChannelRunnableWrapper wrapper = new ChannelRunnableWrapper(pipeline.getChannel(), task);
                channel.worker.executeInIoThread(wrapper);
                return wrapper;
            }
        }
        return super.execute(pipeline, task);
    }

    protected boolean isFireExceptionCaughtLater(ChannelEvent event, Throwable actualCause) {
        Channel channel = event.getChannel();
        boolean fireLater = false;
        if (channel instanceof AbstractOioChannel) {
            fireLater = !AbstractOioWorker.isIoThread((AbstractOioChannel)channel);
        }
        return fireLater;
    }
}

