/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.index.translog.ChannelFactory;

class Checkpoint {
    final long offset;
    final int numOps;
    final long generation;
    private static final int INITIAL_VERSION = 1;
    private static final String CHECKPOINT_CODEC = "ckp";
    static final int FILE_SIZE = CodecUtil.headerLength("ckp") + 4 + 8 + 8 + CodecUtil.footerLength();
    static final int LEGACY_NON_CHECKSUMMED_FILE_LENGTH = 20;

    Checkpoint(long offset, int numOps, long generation) {
        this.offset = offset;
        this.numOps = numOps;
        this.generation = generation;
    }

    private void write(DataOutput out) throws IOException {
        out.writeLong(this.offset);
        out.writeInt(this.numOps);
        out.writeLong(this.generation);
    }

    static Checkpoint readChecksummedV1(DataInput in) throws IOException {
        return new Checkpoint(in.readLong(), in.readInt(), in.readLong());
    }

    static Checkpoint readNonChecksummed(DataInput in) throws IOException {
        return new Checkpoint(in.readLong(), in.readInt(), in.readLong());
    }

    public String toString() {
        return "Checkpoint{offset=" + this.offset + ", numOps=" + this.numOps + ", translogFileGeneration= " + this.generation + '}';
    }

    /*
     * Exception decompiling
     */
    public static Checkpoint read(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void write(ChannelFactory factory, Path checkpointFile, Checkpoint checkpoint, OpenOption ... options) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(FILE_SIZE){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        String resourceDesc = "checkpoint(path=\"" + checkpointFile + "\", gen=" + checkpoint + ")";
        try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput(resourceDesc, checkpointFile.toString(), byteOutputStream, FILE_SIZE);){
            CodecUtil.writeHeader(indexOutput, CHECKPOINT_CODEC, 1);
            checkpoint.write(indexOutput);
            CodecUtil.writeFooter(indexOutput);
            assert (indexOutput.getFilePointer() == (long)FILE_SIZE) : "get you number straights. Bytes written: " + indexOutput.getFilePointer() + " buffer size: " + FILE_SIZE;
            assert (indexOutput.getFilePointer() < 512L) : "checkpoint files have to be smaller 512b for atomic writes. size: " + indexOutput.getFilePointer();
        }
        var7_7 = null;
        try (FileChannel channel = factory.open(checkpointFile, options);){
            Channels.writeToChannel(byteOutputStream.toByteArray(), (WritableByteChannel)channel);
            channel.force(false);
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkpoint that = (Checkpoint)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (this.numOps != that.numOps) {
            return false;
        }
        return this.generation == that.generation;
    }

    public int hashCode() {
        int result = Long.hashCode(this.offset);
        result = 31 * result + this.numOps;
        result = 31 * result + Long.hashCode(this.generation);
        return result;
    }
}

