/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.termvectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.memory.MemoryIndex;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.termvectors.TermVectorsFilter;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.StringFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.search.dfs.AggregatedDfs;

public class TermVectorsService {
    private TermVectorsService() {
    }

    public static TermVectorsResponse getTermVectors(IndexShard indexShard, TermVectorsRequest request) {
        return TermVectorsService.getTermVectors(indexShard, request, System::nanoTime);
    }

    static TermVectorsResponse getTermVectors(IndexShard indexShard, TermVectorsRequest request, LongSupplier nanoTimeSupplier) {
        long startTime = nanoTimeSupplier.getAsLong();
        TermVectorsResponse termVectorsResponse = new TermVectorsResponse(indexShard.shardId().getIndex().getName(), request.type(), request.id());
        Term uidTerm = new Term("_uid", Uid.createUidAsBytes(request.type(), request.id()));
        Engine.GetResult get = indexShard.get(new Engine.Get(request.realtime(), uidTerm).version(request.version()).versionType(request.versionType()));
        Fields termVectorsByField = null;
        AggregatedDfs dfs = null;
        TermVectorsFilter termVectorsFilter = null;
        if (request.selectedFields() != null) {
            TermVectorsService.handleFieldWildcards(indexShard, request);
        }
        Engine.Searcher searcher = indexShard.acquireSearcher("term_vector");
        try {
            Fields topLevelFields = MultiFields.getFields(get.searcher() != null ? get.searcher().reader() : searcher.reader());
            Versions.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
            if (request.doc() != null) {
                termVectorsByField = TermVectorsService.generateTermVectorsFromDoc(indexShard, request);
                if (topLevelFields == null) {
                    topLevelFields = termVectorsByField;
                }
                termVectorsResponse.setArtificial(true);
                termVectorsResponse.setExists(true);
            } else if (docIdAndVersion != null) {
                termVectorsByField = docIdAndVersion.context.reader().getTermVectors(docIdAndVersion.docId);
                Set<String> selectedFields = request.selectedFields();
                if (selectedFields == null && request.perFieldAnalyzer() != null) {
                    selectedFields = TermVectorsService.getFieldsToGenerate(request.perFieldAnalyzer(), termVectorsByField);
                }
                if (selectedFields != null) {
                    termVectorsByField = TermVectorsService.addGeneratedTermVectors(indexShard, get, termVectorsByField, request, selectedFields);
                }
                termVectorsResponse.setDocVersion(docIdAndVersion.version);
                termVectorsResponse.setExists(true);
            } else {
                termVectorsResponse.setExists(false);
            }
            if (termVectorsByField != null) {
                if (request.filterSettings() != null) {
                    termVectorsFilter = new TermVectorsFilter(termVectorsByField, topLevelFields, request.selectedFields(), dfs);
                    termVectorsFilter.setSettings(request.filterSettings());
                    try {
                        termVectorsFilter.selectBestTerms();
                    }
                    catch (IOException e) {
                        throw new ElasticsearchException("failed to select best terms", (Throwable)e, new Object[0]);
                    }
                }
                termVectorsResponse.setFields(termVectorsByField, request.selectedFields(), request.getFlags(), topLevelFields, dfs, termVectorsFilter);
            }
            termVectorsResponse.setTookInMillis(TimeUnit.NANOSECONDS.toMillis(nanoTimeSupplier.getAsLong() - startTime));
        }
        catch (Exception ex) {
            throw new ElasticsearchException("failed to execute term vector request", (Throwable)ex, new Object[0]);
        }
        finally {
            searcher.close();
            get.release();
        }
        return termVectorsResponse;
    }

    private static void handleFieldWildcards(IndexShard indexShard, TermVectorsRequest request) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (String pattern : request.selectedFields()) {
            fieldNames.addAll(indexShard.mapperService().simpleMatchToIndexNames(pattern));
        }
        request.selectedFields(fieldNames.toArray(Strings.EMPTY_ARRAY));
    }

    private static boolean isValidField(MappedFieldType fieldType) {
        if (!(fieldType instanceof StringFieldMapper.StringFieldType || fieldType instanceof KeywordFieldMapper.KeywordFieldType || fieldType instanceof TextFieldMapper.TextFieldType)) {
            return false;
        }
        return fieldType.indexOptions() != IndexOptions.NONE;
    }

    private static Fields addGeneratedTermVectors(IndexShard indexShard, Engine.GetResult get, Fields termVectorsByField, TermVectorsRequest request, Set<String> selectedFields) throws IOException {
        HashSet<String> validFields = new HashSet<String>();
        for (String field : selectedFields) {
            MappedFieldType fieldType = indexShard.mapperService().fullName(field);
            if (!TermVectorsService.isValidField(fieldType) || fieldType.storeTermVectors() && (request.perFieldAnalyzer() == null || !request.perFieldAnalyzer().containsKey(field))) continue;
            validFields.add(field);
        }
        if (validFields.isEmpty()) {
            return termVectorsByField;
        }
        String[] getFields = validFields.toArray(new String[validFields.size() + 1]);
        getFields[getFields.length - 1] = "_source";
        GetResult getResult = indexShard.getService().get(get, request.id(), request.type(), getFields, null);
        Fields generatedTermVectors = TermVectorsService.generateTermVectors(indexShard, getResult.sourceAsMap(), getResult.getFields().values(), request.offsets(), request.perFieldAnalyzer(), validFields);
        if (termVectorsByField == null) {
            return generatedTermVectors;
        }
        return TermVectorsService.mergeFields(termVectorsByField, generatedTermVectors);
    }

    private static Analyzer getAnalyzerAtField(IndexShard indexShard, String field, @Nullable Map<String, String> perFieldAnalyzer) {
        MapperService mapperService = indexShard.mapperService();
        NamedAnalyzer analyzer = perFieldAnalyzer != null && perFieldAnalyzer.containsKey(field) ? mapperService.getIndexAnalyzers().get(perFieldAnalyzer.get(field).toString()) : mapperService.fullName(field).indexAnalyzer();
        if (analyzer == null) {
            analyzer = mapperService.getIndexAnalyzers().getDefaultIndexAnalyzer();
        }
        return analyzer;
    }

    private static Set<String> getFieldsToGenerate(Map<String, String> perAnalyzerField, Fields fieldsObject) {
        HashSet<String> selectedFields = new HashSet<String>();
        for (String fieldName : fieldsObject) {
            if (!perAnalyzerField.containsKey(fieldName)) continue;
            selectedFields.add(fieldName);
        }
        return selectedFields;
    }

    private static Fields generateTermVectors(IndexShard indexShard, Map<String, Object> source, Collection<GetField> getFields, boolean withOffsets, @Nullable Map<String, String> perFieldAnalyzer, Set<String> fields) throws IOException {
        HashMap<String, List<Object>> values = new HashMap<String, List<Object>>();
        for (GetField getField : getFields) {
            String field = getField.getName();
            if (!fields.contains(field)) continue;
            values.put(field, getField.getValues());
        }
        if (source != null) {
            for (String field : fields) {
                List<Object> v;
                if (values.containsKey(field) || (v = XContentMapValues.extractRawValues(field, source)).isEmpty()) continue;
                values.put(field, v);
            }
        }
        MemoryIndex index = new MemoryIndex(withOffsets);
        for (Map.Entry entry : values.entrySet()) {
            String field = (String)entry.getKey();
            Analyzer analyzer = TermVectorsService.getAnalyzerAtField(indexShard, field, perFieldAnalyzer);
            if (entry.getValue() instanceof List) {
                for (Object text : (Collection)entry.getValue()) {
                    index.addField(field, text.toString(), analyzer);
                }
                continue;
            }
            index.addField(field, ((Collection)entry.getValue()).toString(), analyzer);
        }
        return MultiFields.getFields(index.createSearcher().getIndexReader());
    }

    private static Fields generateTermVectorsFromDoc(IndexShard indexShard, TermVectorsRequest request) throws IOException {
        ParsedDocument parsedDocument = TermVectorsService.parseDocument(indexShard, indexShard.shardId().getIndexName(), request.type(), request.doc(), request.xContentType());
        ParseContext.Document doc = parsedDocument.rootDoc();
        HashSet<String> seenFields = new HashSet<String>();
        HashSet<GetField> getFields = new HashSet<GetField>();
        for (IndexableField field : doc.getFields()) {
            MappedFieldType fieldType = indexShard.mapperService().fullName(field.name());
            if (!TermVectorsService.isValidField(fieldType) || request.selectedFields() != null && !request.selectedFields().contains(field.name()) || seenFields.contains(field.name())) continue;
            seenFields.add(field.name());
            String[] values = doc.getValues(field.name());
            getFields.add(new GetField(field.name(), Arrays.asList((Object[])values)));
        }
        return TermVectorsService.generateTermVectors(indexShard, XContentHelper.convertToMap(parsedDocument.source(), true, request.xContentType()).v2(), getFields, request.offsets(), request.perFieldAnalyzer(), seenFields);
    }

    private static ParsedDocument parseDocument(IndexShard indexShard, String index, String type, BytesReference doc, XContentType xContentType) {
        MapperService mapperService = indexShard.mapperService();
        DocumentMapperForType docMapper = mapperService.documentMapperWithAutoCreate(type);
        ParsedDocument parsedDocument = docMapper.getDocumentMapper().parse(SourceToParse.source(index, type, "_id_for_tv_api", doc, xContentType));
        if (docMapper.getMapping() != null) {
            parsedDocument.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        return parsedDocument;
    }

    private static Fields mergeFields(Fields fields1, Fields fields2) throws IOException {
        Terms terms;
        ParallelFields parallelFields = new ParallelFields();
        for (String fieldName : fields2) {
            terms = fields2.terms(fieldName);
            if (terms == null) continue;
            parallelFields.addField(fieldName, terms);
        }
        for (String fieldName : fields1) {
            if (parallelFields.fields.containsKey(fieldName) || (terms = fields1.terms(fieldName)) == null) continue;
            parallelFields.addField(fieldName, terms);
        }
        return parallelFields;
    }

    private static final class ParallelFields
    extends Fields {
        final Map<String, Terms> fields = new TreeMap<String, Terms>();

        ParallelFields() {
        }

        void addField(String fieldName, Terms terms) {
            this.fields.put(fieldName, terms);
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        @Override
        public Terms terms(String field) {
            return this.fields.get(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }
}

