/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class RethrottleRequest
extends BaseTasksRequest<RethrottleRequest> {
    private Float requestsPerSecond;

    public float getRequestsPerSecond() {
        return this.requestsPerSecond.floatValue();
    }

    public RethrottleRequest setRequestsPerSecond(float requestsPerSecond) {
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("[requests_per_second] must be greater than 0. Use Float.POSITIVE_INFINITY to disable throttling.");
        }
        this.requestsPerSecond = Float.valueOf(requestsPerSecond);
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.requestsPerSecond == null) {
            validationException = ValidateActions.addValidationError("requests_per_second must be set", validationException);
        }
        String[] stringArray = this.getActions();
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String action;
            switch (action = stringArray[i]) {
                case "indices:data/write/reindex": 
                case "indices:data/write/update/byquery": 
                case "indices:data/write/delete/byquery": {
                    continue block8;
                }
                default: {
                    validationException = ValidateActions.addValidationError("Can only change the throttling on reindex or update-by-query. Not on [" + action + "]", validationException);
                }
            }
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.requestsPerSecond = Float.valueOf(in.readFloat());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.requestsPerSecond.floatValue());
    }
}

