/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;

public class BoolQueryBuilder
extends AbstractQueryBuilder<BoolQueryBuilder> {
    public static final String NAME = "bool";
    public static final boolean ADJUST_PURE_NEGATIVE_DEFAULT = true;
    public static final boolean DISABLE_COORD_DEFAULT = false;
    private static final String MUSTNOT = "mustNot";
    private static final String MUST_NOT = "must_not";
    private static final String FILTER = "filter";
    private static final String SHOULD = "should";
    private static final String MUST = "must";
    private static final ParseField DISABLE_COORD_FIELD = new ParseField("disable_coord", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH = new ParseField("minimum_should_match", "minimum_number_should_match");
    private static final ParseField ADJUST_PURE_NEGATIVE = new ParseField("adjust_pure_negative", new String[0]);
    private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();
    private boolean disableCoord = false;
    private boolean adjustPureNegative = true;
    private String minimumShouldMatch;

    public BoolQueryBuilder() {
    }

    public BoolQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.mustClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.mustNotClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.shouldClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.filterClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.adjustPureNegative = in.readBoolean();
        this.disableCoord = in.readBoolean();
        this.minimumShouldMatch = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        BoolQueryBuilder.writeQueries(out, this.mustClauses);
        BoolQueryBuilder.writeQueries(out, this.mustNotClauses);
        BoolQueryBuilder.writeQueries(out, this.shouldClauses);
        BoolQueryBuilder.writeQueries(out, this.filterClauses);
        out.writeBoolean(this.adjustPureNegative);
        out.writeBoolean(this.disableCoord);
        out.writeOptionalString(this.minimumShouldMatch);
    }

    public BoolQueryBuilder must(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.mustClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> must() {
        return this.mustClauses;
    }

    public BoolQueryBuilder filter(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.filterClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> filter() {
        return this.filterClauses;
    }

    public BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.mustNotClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> mustNot() {
        return this.mustNotClauses;
    }

    public BoolQueryBuilder should(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.shouldClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> should() {
        return this.shouldClauses;
    }

    public BoolQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    public boolean disableCoord() {
        return this.disableCoord;
    }

    @Deprecated
    public BoolQueryBuilder minimumNumberShouldMatch(int minimumNumberShouldMatch) {
        this.minimumShouldMatch = Integer.toString(minimumNumberShouldMatch);
        return this;
    }

    @Deprecated
    public BoolQueryBuilder minimumNumberShouldMatch(String minimumNumberShouldMatch) {
        this.minimumShouldMatch = minimumNumberShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public BoolQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public BoolQueryBuilder minimumShouldMatch(int minimumShouldMatch) {
        this.minimumShouldMatch = Integer.toString(minimumShouldMatch);
        return this;
    }

    public boolean hasClauses() {
        return !this.mustClauses.isEmpty() || !this.shouldClauses.isEmpty() || !this.mustNotClauses.isEmpty() || !this.filterClauses.isEmpty();
    }

    public BoolQueryBuilder adjustPureNegative(boolean adjustPureNegative) {
        this.adjustPureNegative = adjustPureNegative;
        return this;
    }

    public boolean adjustPureNegative() {
        return this.adjustPureNegative;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        BoolQueryBuilder.doXArrayContent(MUST, this.mustClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(FILTER, this.filterClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(MUST_NOT, this.mustNotClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(SHOULD, this.shouldClauses, builder, params);
        builder.field(DISABLE_COORD_FIELD.getPreferredName(), this.disableCoord);
        builder.field(ADJUST_PURE_NEGATIVE.getPreferredName(), this.adjustPureNegative);
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH.getPreferredName(), this.minimumShouldMatch);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    private static void doXArrayContent(String field, List<QueryBuilder> clauses, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (clauses.isEmpty()) {
            return;
        }
        builder.startArray(field);
        for (QueryBuilder clause : clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
    }

    public static Optional<BoolQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException, ParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean disableCoord = false;
        boolean adjustPureNegative = true;
        float boost = 1.0f;
        String minimumShouldMatch = null;
        ArrayList mustClauses = new ArrayList();
        ArrayList mustNotClauses = new ArrayList();
        ArrayList shouldClauses = new ArrayList();
        ArrayList filterClauses = new ArrayList();
        String queryName = null;
        String currentFieldName = null;
        block26: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                switch (currentFieldName) {
                    case "must": {
                        parseContext.parseInnerQueryBuilder().ifPresent(mustClauses::add);
                        continue block26;
                    }
                    case "should": {
                        parseContext.parseInnerQueryBuilder().ifPresent(shouldClauses::add);
                        continue block26;
                    }
                    case "filter": {
                        parseContext.parseInnerQueryBuilder().ifPresent(filterClauses::add);
                        continue block26;
                    }
                    case "must_not": 
                    case "mustNot": {
                        parseContext.parseInnerQueryBuilder().ifPresent(mustNotClauses::add);
                        continue block26;
                    }
                }
                throw new ParsingException(parser.getTokenLocation(), "[bool] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                block27: while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    switch (currentFieldName) {
                        case "must": {
                            parseContext.parseInnerQueryBuilder().ifPresent(mustClauses::add);
                            continue block27;
                        }
                        case "should": {
                            parseContext.parseInnerQueryBuilder().ifPresent(shouldClauses::add);
                            continue block27;
                        }
                        case "filter": {
                            parseContext.parseInnerQueryBuilder().ifPresent(filterClauses::add);
                            continue block27;
                        }
                        case "must_not": 
                        case "mustNot": {
                            parseContext.parseInnerQueryBuilder().ifPresent(mustNotClauses::add);
                            continue block27;
                        }
                    }
                    throw new ParsingException(parser.getTokenLocation(), "bool query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (DISABLE_COORD_FIELD.match(currentFieldName)) {
                disableCoord = parser.booleanValue();
                continue;
            }
            if (MINIMUM_SHOULD_MATCH.match(currentFieldName)) {
                minimumShouldMatch = parser.textOrNull();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (ADJUST_PURE_NEGATIVE.match(currentFieldName)) {
                adjustPureNegative = parser.booleanValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[bool] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        for (QueryBuilder queryBuilder : mustClauses) {
            boolQuery.must(queryBuilder);
        }
        for (QueryBuilder queryBuilder : mustNotClauses) {
            boolQuery.mustNot(queryBuilder);
        }
        for (QueryBuilder queryBuilder : shouldClauses) {
            boolQuery.should(queryBuilder);
        }
        for (QueryBuilder queryBuilder : filterClauses) {
            boolQuery.filter(queryBuilder);
        }
        boolQuery.boost(boost);
        boolQuery.disableCoord(disableCoord);
        boolQuery.adjustPureNegative(adjustPureNegative);
        boolQuery.minimumShouldMatch(minimumShouldMatch);
        boolQuery.queryName(queryName);
        return Optional.of(boolQuery);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.setDisableCoord(this.disableCoord);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.mustClauses, BooleanClause.Occur.MUST);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.mustNotClauses, BooleanClause.Occur.MUST_NOT);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.shouldClauses, BooleanClause.Occur.SHOULD);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.filterClauses, BooleanClause.Occur.FILTER);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        if (booleanQuery.clauses().isEmpty()) {
            return new MatchAllDocsQuery();
        }
        String minimumShouldMatch = context.isFilter() && this.minimumShouldMatch == null && this.shouldClauses.size() > 0 ? "1" : this.minimumShouldMatch;
        Query query = Queries.applyMinimumShouldMatch(booleanQuery, minimumShouldMatch);
        return this.adjustPureNegative ? Queries.fixNegativeQueryIfNeeded(query) : query;
    }

    private static void addBooleanClauses(QueryShardContext context, BooleanQuery.Builder booleanQueryBuilder, List<QueryBuilder> clauses, BooleanClause.Occur occurs) throws IOException {
        for (QueryBuilder query : clauses) {
            Query luceneQuery = null;
            switch (occurs) {
                case MUST: 
                case SHOULD: {
                    luceneQuery = query.toQuery(context);
                    break;
                }
                case FILTER: 
                case MUST_NOT: {
                    luceneQuery = query.toFilter(context);
                }
            }
            booleanQueryBuilder.add(new BooleanClause(luceneQuery, occurs));
        }
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.adjustPureNegative, this.disableCoord, this.minimumShouldMatch, this.mustClauses, this.shouldClauses, this.mustNotClauses, this.filterClauses);
    }

    @Override
    protected boolean doEquals(BoolQueryBuilder other) {
        return Objects.equals(this.adjustPureNegative, other.adjustPureNegative) && Objects.equals(this.disableCoord, other.disableCoord) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.mustClauses, other.mustClauses) && Objects.equals(this.shouldClauses, other.shouldClauses) && Objects.equals(this.mustNotClauses, other.mustNotClauses) && Objects.equals(this.filterClauses, other.filterClauses);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        BoolQueryBuilder newBuilder = new BoolQueryBuilder();
        boolean changed = false;
        int clauses = this.mustClauses.size() + this.mustNotClauses.size() + this.filterClauses.size() + this.shouldClauses.size();
        if (clauses == 0) {
            return ((MatchAllQueryBuilder)new MatchAllQueryBuilder().boost(this.boost())).queryName(this.queryName());
        }
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.mustClauses, newBuilder::must);
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.mustNotClauses, newBuilder::mustNot);
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.filterClauses, newBuilder::filter);
        if (changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.shouldClauses, newBuilder::should)) {
            newBuilder.adjustPureNegative = this.adjustPureNegative;
            newBuilder.disableCoord = this.disableCoord;
            newBuilder.minimumShouldMatch = this.minimumShouldMatch;
            newBuilder.boost(this.boost());
            newBuilder.queryName(this.queryName());
            return newBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitBuilder> innerHits) {
        ArrayList<QueryBuilder> clauses = new ArrayList<QueryBuilder>(this.filter());
        clauses.addAll(this.must());
        clauses.addAll(this.should());
        for (QueryBuilder clause : clauses) {
            InnerHitBuilder.extractInnerHits(clause, innerHits);
        }
    }

    private static boolean rewriteClauses(QueryRewriteContext queryRewriteContext, List<QueryBuilder> builders, Consumer<QueryBuilder> consumer) throws IOException {
        boolean changed = false;
        for (QueryBuilder builder : builders) {
            QueryBuilder result = builder.rewrite(queryRewriteContext);
            if (result != builder) {
                changed = true;
            }
            consumer.accept(result);
        }
        return changed;
    }
}

