/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanBoostQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.QueryValidationException;

public abstract class AbstractQueryBuilder<QB extends AbstractQueryBuilder<QB>>
extends ToXContentToBytes
implements QueryBuilder {
    public static final float DEFAULT_BOOST = 1.0f;
    public static final ParseField NAME_FIELD = new ParseField("_name", new String[0]);
    public static final ParseField BOOST_FIELD = new ParseField("boost", new String[0]);
    protected String queryName;
    protected float boost = 1.0f;

    protected AbstractQueryBuilder() {
        super(XContentType.JSON);
    }

    protected AbstractQueryBuilder(StreamInput in) throws IOException {
        this.boost = in.readFloat();
        this.queryName = in.readOptionalString();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.boost);
        out.writeOptionalString(this.queryName);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    protected void printBoostAndQueryName(XContentBuilder builder) throws IOException {
        builder.field(BOOST_FIELD.getPreferredName(), this.boost);
        if (this.queryName != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.queryName);
        }
    }

    @Override
    public final Query toQuery(QueryShardContext context) throws IOException {
        Query query = this.doToQuery(context);
        if (query != null) {
            if (this.boost != 1.0f) {
                query = query instanceof SpanQuery ? new SpanBoostQuery((SpanQuery)query, this.boost) : new BoostQuery(query, this.boost);
            }
            if (this.queryName != null) {
                context.addNamedQuery(this.queryName, query);
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Query toFilter(QueryShardContext context) throws IOException {
        Query result = null;
        boolean originalIsFilter = context.isFilter();
        try {
            context.setIsFilter(true);
            result = this.toQuery(context);
        }
        finally {
            context.setIsFilter(originalIsFilter);
        }
        return result;
    }

    protected abstract Query doToQuery(QueryShardContext var1) throws IOException;

    public final QB queryName(String queryName) {
        this.queryName = queryName;
        return (QB)this;
    }

    @Override
    public final String queryName() {
        return this.queryName;
    }

    @Override
    public final float boost() {
        return this.boost;
    }

    public final QB boost(float boost) {
        this.boost = boost;
        return (QB)this;
    }

    protected final QueryValidationException addValidationError(String validationError, QueryValidationException validationException) {
        return QueryValidationException.addValidationError(this.getName(), validationError, validationException);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQueryBuilder other = (AbstractQueryBuilder)obj;
        return Objects.equals(this.queryName, other.queryName) && Objects.equals(Float.valueOf(this.boost), Float.valueOf(other.boost)) && this.doEquals(other);
    }

    protected abstract boolean doEquals(QB var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.queryName, Float.valueOf(this.boost), this.doHashCode());
    }

    protected abstract int doHashCode();

    protected static Object convertToBytesRefIfString(Object obj) {
        if (obj instanceof String) {
            return BytesRefs.toBytesRef(obj);
        }
        return obj;
    }

    protected static Object convertToStringIfBytesRef(Object obj) {
        if (obj instanceof BytesRef) {
            return ((BytesRef)obj).utf8ToString();
        }
        return obj;
    }

    protected static Collection<Query> toQueries(Collection<QueryBuilder> queryBuilders, QueryShardContext context) throws QueryShardException, IOException {
        ArrayList<Query> queries = new ArrayList<Query>(queryBuilders.size());
        for (QueryBuilder queryBuilder : queryBuilders) {
            Query query = queryBuilder.toQuery(context);
            if (query == null) continue;
            queries.add(query);
        }
        return queries;
    }

    @Override
    public String getName() {
        return this.getWriteableName();
    }

    protected static final void writeQueries(StreamOutput out, List<? extends QueryBuilder> queries) throws IOException {
        out.writeVInt(queries.size());
        for (QueryBuilder queryBuilder : queries) {
            out.writeNamedWriteable(queryBuilder);
        }
    }

    protected static final List<QueryBuilder> readQueries(StreamInput in) throws IOException {
        ArrayList<QueryBuilder> queries = new ArrayList<QueryBuilder>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            queries.add(in.readNamedWriteable(QueryBuilder.class));
        }
        return queries;
    }

    @Override
    public final QueryBuilder rewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder rewritten = this.doRewrite(queryShardContext);
        if (rewritten == this) {
            return rewritten;
        }
        if (this.queryName() != null && rewritten.queryName() == null) {
            rewritten.queryName(this.queryName());
        }
        if (this.boost() != 1.0f && rewritten.boost() == 1.0f) {
            rewritten.boost(this.boost());
        }
        return rewritten;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        return this;
    }

    protected void extractInnerHitBuilders(Map<String, InnerHitBuilder> innerHits) {
    }

    protected static <T> T requireValue(T value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    protected static void throwParsingExceptionOnMultipleFields(String queryName, XContentLocation contentLocation, String processedFieldName, String currentFieldName) {
        if (processedFieldName != null) {
            throw new ParsingException(contentLocation, "[" + queryName + "] query doesn't support multiple fields, found [" + processedFieldName + "] and [" + currentFieldName + "]", new Object[0]);
        }
    }

    protected static void declareStandardFields(AbstractObjectParser<? extends QueryBuilder, ?> parser) {
        parser.declareFloat((builder, value) -> builder.boost(value.floatValue()), BOOST_FIELD);
        parser.declareString((builder, value) -> builder.queryName((String)value), NAME_FIELD);
    }
}

