/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final Settings analyzerSettings;
    private CustomAnalyzer customAnalyzer;

    public CustomAnalyzerProvider(IndexSettings indexSettings, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
    }

    public void build(Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        String[] tokenFilterNames;
        String[] charFilterNames;
        String tokenizerName = this.analyzerSettings.get("tokenizer");
        if (tokenizerName == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] must be configured with a tokenizer");
        }
        TokenizerFactory tokenizer = tokenizers.get(tokenizerName);
        if (tokenizer == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find tokenizer under name [" + tokenizerName + "]");
        }
        ArrayList<CharFilterFactory> charFiltersList = new ArrayList<CharFilterFactory>();
        for (String charFilterName : charFilterNames = this.analyzerSettings.getAsArray("char_filter")) {
            CharFilterFactory charFilter = charFilters.get(charFilterName);
            if (charFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find char_filter under name [" + charFilterName + "]");
            }
            charFiltersList.add(charFilter);
        }
        ArrayList<TokenFilterFactory> tokenFilterList = new ArrayList<TokenFilterFactory>();
        for (String tokenFilterName : tokenFilterNames = this.analyzerSettings.getAsArray("filter")) {
            TokenFilterFactory tokenFilter = tokenFilters.get(tokenFilterName);
            if (tokenFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find filter under name [" + tokenFilterName + "]");
            }
            tokenFilterList.add(tokenFilter);
        }
        int positionIncrementGap = 100;
        if (this.analyzerSettings.getAsMap().containsKey("position_offset_gap")) {
            if (this.indexSettings.getIndexVersionCreated().before(Version.V_2_0_0)) {
                if (this.analyzerSettings.getAsMap().containsKey("position_increment_gap")) {
                    throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] defined both [position_offset_gap] and [position_increment_gap], use only [position_increment_gap]");
                }
                positionIncrementGap = this.analyzerSettings.getAsInt("position_offset_gap", positionIncrementGap);
            } else {
                throw new IllegalArgumentException("Option [position_offset_gap] in Custom Analyzer [" + this.name() + "] has been renamed, please use [position_increment_gap] instead.");
            }
        }
        positionIncrementGap = this.analyzerSettings.getAsInt("position_increment_gap", positionIncrementGap);
        int offsetGap = this.analyzerSettings.getAsInt("offset_gap", -1);
        this.customAnalyzer = new CustomAnalyzer(tokenizer, charFiltersList.toArray(new CharFilterFactory[charFiltersList.size()]), tokenFilterList.toArray(new TokenFilterFactory[tokenFilterList.size()]), positionIncrementGap, offsetGap);
    }

    @Override
    public CustomAnalyzer get() {
        return this.customAnalyzer;
    }
}

