/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.cors;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfigBuilder;
import org.elasticsearch.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.elasticsearch.io.netty.handler.codec.http.EmptyHttpHeaders;
import org.elasticsearch.io.netty.handler.codec.http.HttpHeaders;
import org.elasticsearch.io.netty.handler.codec.http.HttpMethod;

public final class Netty4CorsConfig {
    private final Optional<Set<String>> origins;
    private final Optional<Pattern> pattern;
    private final boolean anyOrigin;
    private final boolean enabled;
    private final boolean allowCredentials;
    private final long maxAge;
    private final Set<HttpMethod> allowedRequestMethods;
    private final Set<String> allowedRequestHeaders;
    private final boolean allowNullOrigin;
    private final Map<CharSequence, Callable<?>> preflightHeaders;
    private final boolean shortCircuit;

    Netty4CorsConfig(Netty4CorsConfigBuilder builder) {
        this.origins = builder.origins.map(s -> new LinkedHashSet(s));
        this.pattern = builder.pattern;
        this.anyOrigin = builder.anyOrigin;
        this.enabled = builder.enabled;
        this.allowCredentials = builder.allowCredentials;
        this.maxAge = builder.maxAge;
        this.allowedRequestMethods = builder.requestMethods;
        this.allowedRequestHeaders = builder.requestHeaders;
        this.allowNullOrigin = builder.allowNullOrigin;
        this.preflightHeaders = builder.preflightHeaders;
        this.shortCircuit = builder.shortCircuit;
    }

    public boolean isCorsSupportEnabled() {
        return this.enabled;
    }

    public boolean isAnyOriginSupported() {
        return this.anyOrigin;
    }

    public Optional<Set<String>> origins() {
        return this.origins;
    }

    public boolean isOriginAllowed(String origin) {
        if (this.origins.isPresent()) {
            return this.origins.get().contains(origin);
        }
        if (this.pattern.isPresent()) {
            return this.pattern.get().matcher(origin).matches();
        }
        return false;
    }

    public boolean isNullOriginAllowed() {
        return this.allowNullOrigin;
    }

    public boolean isCredentialsAllowed() {
        return this.allowCredentials;
    }

    public long maxAge() {
        return this.maxAge;
    }

    public Set<HttpMethod> allowedRequestMethods() {
        return Collections.unmodifiableSet(this.allowedRequestMethods);
    }

    public Set<String> allowedRequestHeaders() {
        return Collections.unmodifiableSet(this.allowedRequestHeaders);
    }

    public HttpHeaders preflightResponseHeaders() {
        if (this.preflightHeaders.isEmpty()) {
            return EmptyHttpHeaders.INSTANCE;
        }
        DefaultHttpHeaders preflightHeaders = new DefaultHttpHeaders();
        for (Map.Entry<CharSequence, Callable<?>> entry : this.preflightHeaders.entrySet()) {
            Object value = Netty4CorsConfig.getValue(entry.getValue());
            if (value instanceof Iterable) {
                ((HttpHeaders)preflightHeaders).add(entry.getKey().toString(), (Iterable)value);
                continue;
            }
            ((HttpHeaders)preflightHeaders).add(entry.getKey().toString(), value);
        }
        return preflightHeaders;
    }

    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    private static <T> T getValue(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not generate value for callable [" + callable + ']', e);
        }
    }

    public String toString() {
        return "CorsConfig[enabled=" + this.enabled + ", origins=" + this.origins + ", anyOrigin=" + this.anyOrigin + ", isCredentialsAllowed=" + this.allowCredentials + ", maxAge=" + this.maxAge + ", allowedRequestMethods=" + this.allowedRequestMethods + ", allowedRequestHeaders=" + this.allowedRequestHeaders + ", preflightHeaders=" + this.preflightHeaders + ']';
    }
}

