/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;

public class RoutingTable
implements Iterable<IndexRoutingTable>,
Diffable<RoutingTable> {
    public static final RoutingTable EMPTY_ROUTING_TABLE = RoutingTable.builder().build();
    private final long version;
    private final ImmutableOpenMap<String, IndexRoutingTable> indicesRouting;
    private static Predicate<ShardRouting> ACTIVE_PREDICATE = shardRouting -> shardRouting.active();
    private static Predicate<ShardRouting> ASSIGNED_PREDICATE = shardRouting -> shardRouting.assignedToNode();

    RoutingTable(long version, ImmutableOpenMap<String, IndexRoutingTable> indicesRouting) {
        this.version = version;
        this.indicesRouting = indicesRouting;
    }

    public long version() {
        return this.version;
    }

    @Override
    public Iterator<IndexRoutingTable> iterator() {
        return this.indicesRouting.valuesIt();
    }

    public boolean hasIndex(String index) {
        return this.indicesRouting.containsKey(index);
    }

    public boolean hasIndex(Index index) {
        IndexRoutingTable indexRouting = this.index(index.getName());
        return indexRouting != null && indexRouting.getIndex().equals(index);
    }

    public IndexRoutingTable index(String index) {
        return this.indicesRouting.get(index);
    }

    public IndexRoutingTable index(Index index) {
        return this.indicesRouting.get(index.getName());
    }

    public ImmutableOpenMap<String, IndexRoutingTable> indicesRouting() {
        return this.indicesRouting;
    }

    public ImmutableOpenMap<String, IndexRoutingTable> getIndicesRouting() {
        return this.indicesRouting();
    }

    public IndexShardRoutingTable shardRoutingTable(String index, int shardId) {
        IndexRoutingTable indexRouting = this.index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        IndexShardRoutingTable shard = indexRouting.shard(shardId);
        if (shard == null) {
            throw new ShardNotFoundException(new ShardId(indexRouting.getIndex(), shardId));
        }
        return shard;
    }

    public IndexShardRoutingTable shardRoutingTable(ShardId shardId) {
        IndexRoutingTable indexRouting = this.index(shardId.getIndexName());
        if (indexRouting == null || !indexRouting.getIndex().equals(shardId.getIndex())) {
            throw new IndexNotFoundException(shardId.getIndex());
        }
        IndexShardRoutingTable shard = indexRouting.shard(shardId.id());
        if (shard == null) {
            throw new ShardNotFoundException(shardId);
        }
        return shard;
    }

    public IndexShardRoutingTable shardRoutingTableOrNull(ShardId shardId) {
        return Optional.ofNullable(this.index(shardId.getIndexName())).flatMap(irt -> Optional.ofNullable(irt.shard(shardId.getId()))).orElse(null);
    }

    @Nullable
    public ShardRouting getByAllocationId(ShardId shardId, String allocationId) {
        IndexShardRoutingTable shardRoutingTable = this.shardRoutingTableOrNull(shardId);
        if (shardRoutingTable == null) {
            return null;
        }
        for (ShardRouting shardRouting : shardRoutingTable.assignedShards()) {
            if (shardRouting.allocationId().getId().equals(allocationId)) {
                return shardRouting;
            }
            if (!shardRouting.relocating() || !shardRouting.getTargetRelocatingShard().allocationId().getId().equals(allocationId)) continue;
            return shardRouting.getTargetRelocatingShard();
        }
        return null;
    }

    public boolean validate(MetaData metaData) {
        for (IndexRoutingTable indexRoutingTable : this) {
            if (indexRoutingTable.validate(metaData)) continue;
            return false;
        }
        return true;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (IndexRoutingTable indexRoutingTable : this) {
            shards.addAll(indexRoutingTable.shardsWithState(state));
        }
        return shards;
    }

    public List<ShardRouting> allShards() {
        String[] indices;
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (String index : indices = this.indicesRouting.keys().toArray(String.class)) {
            List<ShardRouting> allShardsIndex = this.allShards(index);
            shards.addAll(allShardsIndex);
        }
        return shards;
    }

    public List<ShardRouting> allShards(String index) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        IndexRoutingTable indexRoutingTable = this.index(index);
        if (indexRoutingTable == null) {
            throw new IndexNotFoundException(index);
        }
        for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
            for (ShardRouting shardRouting : indexShardRoutingTable) {
                shards.add(shardRouting);
            }
        }
        return shards;
    }

    public GroupShardsIterator allActiveShardsGrouped(String[] indices, boolean includeEmpty) {
        return this.allActiveShardsGrouped(indices, includeEmpty, false);
    }

    public GroupShardsIterator allActiveShardsGrouped(String[] indices, boolean includeEmpty, boolean includeRelocationTargets) {
        return this.allSatisfyingPredicateShardsGrouped(indices, includeEmpty, includeRelocationTargets, ACTIVE_PREDICATE);
    }

    public GroupShardsIterator allAssignedShardsGrouped(String[] indices, boolean includeEmpty) {
        return this.allAssignedShardsGrouped(indices, includeEmpty, false);
    }

    public GroupShardsIterator allAssignedShardsGrouped(String[] indices, boolean includeEmpty, boolean includeRelocationTargets) {
        return this.allSatisfyingPredicateShardsGrouped(indices, includeEmpty, includeRelocationTargets, ASSIGNED_PREDICATE);
    }

    private GroupShardsIterator allSatisfyingPredicateShardsGrouped(String[] indices, boolean includeEmpty, boolean includeRelocationTargets, Predicate<ShardRouting> predicate) {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (predicate.test(shardRouting)) {
                        set.add(shardRouting.shardsIt());
                        if (!includeRelocationTargets || !shardRouting.relocating()) continue;
                        set.add(new PlainShardIterator(shardRouting.shardId(), Collections.singletonList(shardRouting.getTargetRelocatingShard())));
                        continue;
                    }
                    if (!includeEmpty) continue;
                    set.add(new PlainShardIterator(shardRouting.shardId(), Collections.emptyList()));
                }
            }
        }
        return new GroupShardsIterator(set);
    }

    public ShardsIterator allShards(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, shardRouting -> true, false);
    }

    public ShardsIterator allShardsIncludingRelocationTargets(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, shardRouting -> true, true);
    }

    private ShardsIterator allShardsSatisfyingPredicate(String[] indices, Predicate<ShardRouting> predicate, boolean includeRelocationTargets) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (!predicate.test(shardRouting)) continue;
                    shards.add(shardRouting);
                    if (!includeRelocationTargets || !shardRouting.relocating()) continue;
                    shards.add(shardRouting.getTargetRelocatingShard());
                }
            }
        }
        return new PlainShardsIterator(shards);
    }

    public GroupShardsIterator activePrimaryShardsGrouped(String[] indices, boolean includeEmpty) {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) {
                throw new IndexNotFoundException(index);
            }
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                ShardRouting primary = indexShardRoutingTable.primaryShard();
                if (primary.active()) {
                    set.add(primary.shardsIt());
                    continue;
                }
                if (!includeEmpty) continue;
                set.add(new PlainShardIterator(primary.shardId(), Collections.emptyList()));
            }
        }
        return new GroupShardsIterator(set);
    }

    @Override
    public Diff<RoutingTable> diff(RoutingTable previousState) {
        return new RoutingTableDiff(previousState, this);
    }

    public static Diff<RoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return new RoutingTableDiff(in);
    }

    public static RoutingTable readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder();
        builder.version = in.readLong();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            IndexRoutingTable index = IndexRoutingTable.readFrom(in);
            builder.add(index);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeVInt(this.indicesRouting.size());
        for (ObjectCursor<IndexRoutingTable> objectCursor : this.indicesRouting.values()) {
            ((IndexRoutingTable)objectCursor.value).writeTo(out);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RoutingTable routingTable) {
        return new Builder(routingTable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("routing_table (version ").append(this.version).append("):\n");
        for (ObjectObjectCursor<String, IndexRoutingTable> objectObjectCursor : this.indicesRouting) {
            sb.append(((IndexRoutingTable)objectObjectCursor.value).prettyPrint()).append('\n');
        }
        return sb.toString();
    }

    public static class Builder {
        private long version;
        private ImmutableOpenMap.Builder<String, IndexRoutingTable> indicesRouting = ImmutableOpenMap.builder();

        public Builder() {
        }

        public Builder(RoutingTable routingTable) {
            this.version = routingTable.version;
            for (IndexRoutingTable indexRoutingTable : routingTable) {
                this.indicesRouting.put(indexRoutingTable.getIndex().getName(), indexRoutingTable);
            }
        }

        public Builder updateNodes(long version, RoutingNodes routingNodes) {
            this.version = version;
            HashMap<String, IndexRoutingTable.Builder> indexRoutingTableBuilders = new HashMap<String, IndexRoutingTable.Builder>();
            for (RoutingNode routingNode : routingNodes) {
                for (ShardRouting shardRoutingEntry : routingNode) {
                    if (shardRoutingEntry.initializing() && shardRoutingEntry.relocatingNodeId() != null) continue;
                    Index index = shardRoutingEntry.index();
                    IndexRoutingTable.Builder indexBuilder = (IndexRoutingTable.Builder)indexRoutingTableBuilders.get(index.getName());
                    if (indexBuilder == null) {
                        indexBuilder = new IndexRoutingTable.Builder(index);
                        indexRoutingTableBuilders.put(index.getName(), indexBuilder);
                    }
                    indexBuilder.addShard(shardRoutingEntry);
                }
            }
            Iterable<ShardRouting> shardRoutingEntries = Iterables.concat(routingNodes.unassigned(), routingNodes.unassigned().ignored());
            for (ShardRouting shardRoutingEntry : shardRoutingEntries) {
                Index index = shardRoutingEntry.index();
                IndexRoutingTable.Builder indexBuilder = (IndexRoutingTable.Builder)indexRoutingTableBuilders.get(index.getName());
                if (indexBuilder == null) {
                    indexBuilder = new IndexRoutingTable.Builder(index);
                    indexRoutingTableBuilders.put(index.getName(), indexBuilder);
                }
                indexBuilder.addShard(shardRoutingEntry);
            }
            for (IndexRoutingTable.Builder indexBuilder : indexRoutingTableBuilders.values()) {
                this.add(indexBuilder);
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            if (indices == null || indices.length == 0) {
                indices = this.indicesRouting.keys().toArray(String.class);
            }
            for (String index : indices) {
                int delta;
                IndexRoutingTable indexRoutingTable = this.indicesRouting.get(index);
                if (indexRoutingTable == null) continue;
                int currentNumberOfReplicas = indexRoutingTable.shards().get(0).size() - 1;
                IndexRoutingTable.Builder builder = new IndexRoutingTable.Builder(indexRoutingTable.getIndex());
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.addIndexShard(indexShardRoutingTable);
                }
                if (currentNumberOfReplicas < numberOfReplicas) {
                    for (int i = 0; i < numberOfReplicas - currentNumberOfReplicas; ++i) {
                        builder.addReplica();
                    }
                } else if (currentNumberOfReplicas > numberOfReplicas && (delta = currentNumberOfReplicas - numberOfReplicas) > 0) {
                    for (int i = 0; i < delta; ++i) {
                        builder.removeReplica();
                    }
                }
                this.indicesRouting.put(index, builder.build());
            }
            return this;
        }

        public Builder addAsNew(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsNew(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsRecovery(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsRecovery(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromDangling(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsFromDangling(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromCloseToOpen(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsFromCloseToOpen(indexMetaData);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsRestore(IndexMetaData indexMetaData, RecoverySource.SnapshotRecoverySource recoverySource) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsRestore(indexMetaData, recoverySource);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder addAsNewRestore(IndexMetaData indexMetaData, RecoverySource.SnapshotRecoverySource recoverySource, IntSet ignoreShards) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetaData.getIndex()).initializeAsNewRestore(indexMetaData, recoverySource, ignoreShards);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder add(IndexRoutingTable indexRoutingTable) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            this.indicesRouting.put(indexRoutingTable.getIndex().getName(), indexRoutingTable);
            return this;
        }

        public Builder add(IndexRoutingTable.Builder indexRoutingTableBuilder) {
            this.add(indexRoutingTableBuilder.build());
            return this;
        }

        public Builder indicesRouting(Map<String, IndexRoutingTable> indicesRouting) {
            if (indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            this.indicesRouting.putAll(indicesRouting);
            return this;
        }

        public Builder remove(String index) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            this.indicesRouting.remove(index);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public RoutingTable build() {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            RoutingTable table = new RoutingTable(this.version, this.indicesRouting.build());
            this.indicesRouting = null;
            return table;
        }
    }

    private static class RoutingTableDiff
    implements Diff<RoutingTable> {
        private final long version;
        private final Diff<ImmutableOpenMap<String, IndexRoutingTable>> indicesRouting;

        RoutingTableDiff(RoutingTable before, RoutingTable after) {
            this.version = after.version;
            this.indicesRouting = DiffableUtils.diff(before.indicesRouting, after.indicesRouting, DiffableUtils.getStringKeySerializer());
        }

        RoutingTableDiff(StreamInput in) throws IOException {
            this.version = in.readLong();
            this.indicesRouting = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), IndexRoutingTable::readFrom, IndexRoutingTable::readDiffFrom);
        }

        @Override
        public RoutingTable apply(RoutingTable part) {
            return new RoutingTable(this.version, this.indicesRouting.apply(part.indicesRouting));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.version);
            this.indicesRouting.writeTo(out);
        }
    }
}

