/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;

public final class ResponseException
extends IOException {
    private Response response;

    public ResponseException(Response response) throws IOException {
        super(ResponseException.buildMessage(response));
        this.response = response;
    }

    private static String buildMessage(Response response) throws IOException {
        String message = response.getRequestLine().getMethod() + " " + response.getHost() + response.getRequestLine().getUri() + ": " + response.getStatusLine().toString();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
                response.getHttpResponse().setEntity(entity);
            }
            message = message + "\n" + EntityUtils.toString(entity);
        }
        return message;
    }

    public Response getResponse() {
        return this.response;
    }
}

