/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.RemoteClusterService;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TaskAwareTransportRequestHandler;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class SearchTransportService
extends AbstractLifecycleComponent {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    @Deprecated
    public static final String QUERY_FETCH_ACTION_NAME = "indices:data/read/search[phase/query+fetch]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    private final TransportService transportService;
    private final RemoteClusterService remoteClusterService;
    private final boolean connectToRemote;

    public SearchTransportService(Settings settings, ClusterSettings clusterSettings, TransportService transportService) {
        super(settings);
        this.connectToRemote = RemoteClusterService.ENABLE_REMOTE_CLUSTERS.get(settings);
        this.transportService = transportService;
        this.remoteClusterService = new RemoteClusterService(settings, transportService);
        if (this.connectToRemote) {
            clusterSettings.addAffixUpdateConsumer(RemoteClusterService.REMOTE_CLUSTERS_SEEDS, this.remoteClusterService::updateRemoteCluster, (namespace, value) -> {});
        }
    }

    public void sendFreeContext(Transport.Connection connection, long contextId, SearchRequest request) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_ACTION_NAME, (TransportRequest)new SearchFreeContextRequest(request, contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(new ActionListener<SearchFreeContextResponse>(){

            @Override
            public void onResponse(SearchFreeContextResponse response) {
            }

            @Override
            public void onFailure(Exception e) {
            }
        }, SearchFreeContextResponse::new));
    }

    public void sendFreeContext(DiscoveryNode node, long contextId, ActionListener<SearchFreeContextResponse> listener) {
        this.transportService.sendRequest(node, FREE_CONTEXT_SCROLL_ACTION_NAME, new ScrollFreeContextRequest(contextId), new ActionListenerResponseHandler<SearchFreeContextResponse>(listener, SearchFreeContextResponse::new));
    }

    public void sendClearAllScrollContexts(DiscoveryNode node, ActionListener<TransportResponse> listener) {
        this.transportService.sendRequest(node, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, TransportRequest.Empty.INSTANCE, new ActionListenerResponseHandler<TransportResponse>(listener, () -> TransportResponse.Empty.INSTANCE));
    }

    public void sendExecuteDfs(Transport.Connection connection, ShardSearchTransportRequest request, SearchTask task, ActionListener<DfsSearchResult> listener) {
        this.transportService.sendChildRequest(connection, DFS_ACTION_NAME, request, task, new ActionListenerResponseHandler<DfsSearchResult>(listener, DfsSearchResult::new));
    }

    public void sendExecuteQuery(Transport.Connection connection, ShardSearchTransportRequest request, SearchTask task, ActionListener<QuerySearchResultProvider> listener) {
        Supplier<QuerySearchResultProvider> supplier;
        boolean fetchDocuments = request.numberOfShards() == 1;
        Supplier<QuerySearchResultProvider> supplier2 = supplier = fetchDocuments ? QueryFetchSearchResult::new : QuerySearchResult::new;
        if (connection.getVersion().before(Version.V_5_3_0_UNRELEASED) && fetchDocuments) {
            this.transportService.sendChildRequest(connection, QUERY_FETCH_ACTION_NAME, request, task, new ActionListenerResponseHandler<QuerySearchResultProvider>(listener, supplier));
        } else {
            this.transportService.sendChildRequest(connection, QUERY_ACTION_NAME, request, task, new ActionListenerResponseHandler<QuerySearchResultProvider>(listener, supplier));
        }
    }

    public void sendExecuteQuery(Transport.Connection connection, QuerySearchRequest request, SearchTask task, ActionListener<QuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_ID_ACTION_NAME, request, task, new ActionListenerResponseHandler<QuerySearchResult>(listener, QuerySearchResult::new));
    }

    public void sendExecuteQuery(DiscoveryNode node, InternalScrollSearchRequest request, SearchTask task, ActionListener<ScrollQuerySearchResult> listener) {
        this.transportService.sendChildRequest(this.transportService.getConnection(node), QUERY_SCROLL_ACTION_NAME, request, task, new ActionListenerResponseHandler<ScrollQuerySearchResult>(listener, ScrollQuerySearchResult::new));
    }

    public void sendExecuteFetch(DiscoveryNode node, InternalScrollSearchRequest request, SearchTask task, ActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendChildRequest(this.transportService.getConnection(node), QUERY_FETCH_SCROLL_ACTION_NAME, request, task, new ActionListenerResponseHandler<ScrollQueryFetchSearchResult>(listener, ScrollQueryFetchSearchResult::new));
    }

    public void sendExecuteFetch(Transport.Connection connection, ShardFetchSearchRequest request, SearchTask task, ActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_ACTION_NAME, request, task, listener);
    }

    public void sendExecuteFetchScroll(DiscoveryNode node, ShardFetchRequest request, SearchTask task, ActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(this.transportService.getConnection(node), FETCH_ID_SCROLL_ACTION_NAME, request, task, listener);
    }

    private void sendExecuteFetch(Transport.Connection connection, String action, ShardFetchRequest request, SearchTask task, ActionListener<FetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, action, request, task, new ActionListenerResponseHandler<FetchSearchResult>(listener, FetchSearchResult::new));
    }

    void sendExecuteMultiSearch(DiscoveryNode node, MultiSearchRequest request, SearchTask task, ActionListener<MultiSearchResponse> listener) {
        this.transportService.sendChildRequest(this.transportService.getConnection(node), "indices:data/read/msearch", request, task, new ActionListenerResponseHandler<MultiSearchResponse>(listener, MultiSearchResponse::new));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.remoteClusterService;
    }

    public static void registerRequestHandler(TransportService transportService, final SearchService searchService) {
        transportService.registerRequestHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, ScrollFreeContextRequest::new, "same", new TaskAwareTransportRequestHandler<ScrollFreeContextRequest>(){

            @Override
            public void messageReceived(ScrollFreeContextRequest request, TransportChannel channel, Task task) throws Exception {
                boolean freed = searchService.freeContext(request.id());
                channel.sendResponse(new SearchFreeContextResponse(freed));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_SCROLL_ACTION_NAME, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(FREE_CONTEXT_ACTION_NAME, SearchFreeContextRequest::new, "same", new TaskAwareTransportRequestHandler<SearchFreeContextRequest>(){

            @Override
            public void messageReceived(SearchFreeContextRequest request, TransportChannel channel, Task task) throws Exception {
                boolean freed = searchService.freeContext(request.id());
                channel.sendResponse(new SearchFreeContextResponse(freed));
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_ACTION_NAME, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, () -> TransportRequest.Empty.INSTANCE, "same", new TaskAwareTransportRequestHandler<TransportRequest.Empty>(){

            @Override
            public void messageReceived(TransportRequest.Empty request, TransportChannel channel, Task task) throws Exception {
                searchService.freeAllScrollContexts();
                channel.sendResponse(TransportResponse.Empty.INSTANCE);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, () -> TransportResponse.Empty.INSTANCE);
        transportService.registerRequestHandler(DFS_ACTION_NAME, ShardSearchTransportRequest::new, "search", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) throws Exception {
                DfsSearchResult result = searchService.executeDfsPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, DFS_ACTION_NAME, DfsSearchResult::new);
        transportService.registerRequestHandler(QUERY_ACTION_NAME, ShardSearchTransportRequest::new, "search", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) throws Exception {
                QuerySearchResultProvider result = searchService.executeQueryPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_ACTION_NAME, QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_ID_ACTION_NAME, QuerySearchRequest::new, "search", new TaskAwareTransportRequestHandler<QuerySearchRequest>(){

            @Override
            public void messageReceived(QuerySearchRequest request, TransportChannel channel, Task task) throws Exception {
                QuerySearchResult result = searchService.executeQueryPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_ID_ACTION_NAME, QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_SCROLL_ACTION_NAME, InternalScrollSearchRequest::new, "search", new TaskAwareTransportRequestHandler<InternalScrollSearchRequest>(){

            @Override
            public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel, Task task) throws Exception {
                ScrollQuerySearchResult result = searchService.executeQueryPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_SCROLL_ACTION_NAME, ScrollQuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_FETCH_ACTION_NAME, ShardSearchTransportRequest::new, "search", new TaskAwareTransportRequestHandler<ShardSearchTransportRequest>(){

            @Override
            public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel, Task task) throws Exception {
                assert (request.numberOfShards() == 1) : "expected single shard request but got: " + request.numberOfShards();
                QuerySearchResultProvider result = searchService.executeQueryPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_ACTION_NAME, QueryFetchSearchResult::new);
        transportService.registerRequestHandler(QUERY_FETCH_SCROLL_ACTION_NAME, InternalScrollSearchRequest::new, "search", new TaskAwareTransportRequestHandler<InternalScrollSearchRequest>(){

            @Override
            public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel, Task task) throws Exception {
                ScrollQueryFetchSearchResult result = searchService.executeFetchPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_SCROLL_ACTION_NAME, ScrollQueryFetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_SCROLL_ACTION_NAME, ShardFetchRequest::new, "search", new TaskAwareTransportRequestHandler<ShardFetchRequest>(){

            @Override
            public void messageReceived(ShardFetchRequest request, TransportChannel channel, Task task) throws Exception {
                FetchSearchResult result = searchService.executeFetchPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_SCROLL_ACTION_NAME, FetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_ACTION_NAME, ShardFetchSearchRequest::new, "search", new TaskAwareTransportRequestHandler<ShardFetchSearchRequest>(){

            @Override
            public void messageReceived(ShardFetchSearchRequest request, TransportChannel channel, Task task) throws Exception {
                FetchSearchResult result = searchService.executeFetchPhase(request, (SearchTask)task);
                channel.sendResponse(result);
            }
        });
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_ACTION_NAME, FetchSearchResult::new);
    }

    Transport.Connection getConnection(DiscoveryNode node) {
        return this.transportService.getConnection(node);
    }

    @Override
    protected void doStart() {
        if (this.connectToRemote) {
            this.remoteClusterService.initializeRemoteClusters();
        }
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
        this.remoteClusterService.close();
    }

    public static class SearchFreeContextResponse
    extends TransportResponse {
        private boolean freed;

        SearchFreeContextResponse() {
        }

        SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.freed = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.freed);
        }
    }

    static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private OriginalIndices originalIndices;

        SearchFreeContextRequest() {
        }

        SearchFreeContextRequest(SearchRequest request, long id) {
            super(id);
            this.originalIndices = new OriginalIndices(request);
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }
    }

    static class ScrollFreeContextRequest
    extends TransportRequest {
        private long id;

        ScrollFreeContextRequest() {
        }

        ScrollFreeContextRequest(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.id);
        }
    }
}

