/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class SearchScrollRequest
extends ActionRequest {
    private String scrollId;
    private Scroll scroll;

    public SearchScrollRequest() {
    }

    public SearchScrollRequest(String scrollId) {
        this.scrollId = scrollId;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scrollId == null) {
            validationException = ValidateActions.addValidationError("scrollId is missing", validationException);
        }
        return validationException;
    }

    public String scrollId() {
        return this.scrollId;
    }

    public SearchScrollRequest scrollId(String scrollId) {
        this.scrollId = scrollId;
        return this;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchScrollRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchScrollRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchScrollRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue(keepAlive, null, this.getClass().getSimpleName() + ".keepAlive")));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.scrollId = in.readString();
        this.scroll = in.readOptionalWriteable(Scroll::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.scrollId);
        out.writeOptionalWriteable(this.scroll);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId) {
        return new SearchTask(id, type, action, this.getDescription(), parentTaskId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchScrollRequest that = (SearchScrollRequest)o;
        return Objects.equals(this.scrollId, that.scrollId) && Objects.equals(this.scroll, that.scroll);
    }

    public int hashCode() {
        return Objects.hash(this.scrollId, this.scroll);
    }

    public String toString() {
        return "SearchScrollRequest{scrollId='" + this.scrollId + '\'' + ", scroll=" + this.scroll + '}';
    }

    @Override
    public String getDescription() {
        return "scrollId[" + this.scrollId + "], scroll[" + this.scroll + "]";
    }
}

