/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FieldStatsResponse
extends BroadcastResponse {
    private Map<String, Map<String, FieldStats>> indicesMergedFieldStats;
    private Map<String, String> conflicts;

    public FieldStatsResponse() {
    }

    public FieldStatsResponse(int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures, Map<String, Map<String, FieldStats>> indicesMergedFieldStats, Map<String, String> conflicts) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.indicesMergedFieldStats = indicesMergedFieldStats;
        this.conflicts = conflicts;
    }

    @Nullable
    public Map<String, FieldStats> getAllFieldStats() {
        return this.indicesMergedFieldStats.get("_all");
    }

    public Map<String, String> getConflicts() {
        return this.conflicts;
    }

    public Map<String, Map<String, FieldStats>> getIndicesMergedFieldStats() {
        return this.indicesMergedFieldStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        String key;
        int i;
        super.readFrom(in);
        int size = in.readVInt();
        this.indicesMergedFieldStats = new HashMap<String, Map<String, FieldStats>>(size);
        for (i = 0; i < size; ++i) {
            key = in.readString();
            int indexSize = in.readVInt();
            HashMap<String, FieldStats> indexFieldStats = new HashMap<String, FieldStats>(indexSize);
            this.indicesMergedFieldStats.put(key, indexFieldStats);
            for (int j = 0; j < indexSize; ++j) {
                key = in.readString();
                FieldStats value = FieldStats.readFrom(in);
                indexFieldStats.put(key, value);
            }
        }
        size = in.readVInt();
        this.conflicts = new HashMap<String, String>(size);
        for (i = 0; i < size; ++i) {
            key = in.readString();
            String value = in.readString();
            this.conflicts.put(key, value);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indicesMergedFieldStats.size());
        for (Map.Entry<String, Map<String, FieldStats>> entry : this.indicesMergedFieldStats.entrySet()) {
            out.writeString(entry.getKey());
            int size = entry.getValue().size();
            if (out.getVersion().before(Version.V_5_2_0_UNRELEASED)) {
                for (FieldStats fieldStats : entry.getValue().values()) {
                    if (fieldStats.hasMinMax()) continue;
                    --size;
                }
            }
            out.writeVInt(size);
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                if (!((FieldStats)entry2.getValue()).hasMinMax() && !out.getVersion().onOrAfter(Version.V_5_2_0_UNRELEASED)) continue;
                out.writeString((String)entry2.getKey());
                ((FieldStats)entry2.getValue()).writeTo(out);
            }
        }
        out.writeVInt(this.conflicts.size());
        for (Map.Entry<String, Object> entry : this.conflicts.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString((String)entry.getValue());
        }
    }
}

