/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class BulkResponse
extends ActionResponse
implements Iterable<BulkItemResponse> {
    public static final long NO_INGEST_TOOK = -1L;
    private BulkItemResponse[] responses;
    private long tookInMillis;
    private long ingestTookInMillis;

    BulkResponse() {
    }

    public BulkResponse(BulkItemResponse[] responses, long tookInMillis) {
        this(responses, tookInMillis, -1L);
    }

    public BulkResponse(BulkItemResponse[] responses, long tookInMillis, long ingestTookInMillis) {
        this.responses = responses;
        this.tookInMillis = tookInMillis;
        this.ingestTookInMillis = ingestTookInMillis;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public TimeValue getIngestTook() {
        return new TimeValue(this.ingestTookInMillis);
    }

    public long getIngestTookInMillis() {
        return this.ingestTookInMillis;
    }

    public boolean hasFailures() {
        for (BulkItemResponse response : this.responses) {
            if (!response.isFailed()) continue;
            return true;
        }
        return false;
    }

    public String buildFailureMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("failure in bulk execution:");
        for (int i = 0; i < this.responses.length; ++i) {
            BulkItemResponse response = this.responses[i];
            if (!response.isFailed()) continue;
            sb.append("\n[").append(i).append("]: index [").append(response.getIndex()).append("], type [").append(response.getType()).append("], id [").append(response.getId()).append("], message [").append(response.getFailureMessage()).append("]");
        }
        return sb.toString();
    }

    public BulkItemResponse[] getItems() {
        return this.responses;
    }

    @Override
    public Iterator<BulkItemResponse> iterator() {
        return Arrays.stream(this.responses).iterator();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.responses = new BulkItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = BulkItemResponse.readBulkItem(in);
        }
        this.tookInMillis = in.readVLong();
        this.ingestTookInMillis = in.readZLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.responses.length);
        for (BulkItemResponse response : this.responses) {
            response.writeTo(out);
        }
        out.writeVLong(this.tookInMillis);
        out.writeZLong(this.ingestTookInMillis);
    }
}

