/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.uhighlight.CompositeOffsetsPostingsEnum;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public abstract class FieldOffsetStrategy {
    protected final String field;
    protected final PhraseHelper phraseHelper;
    protected final BytesRef[] terms;
    protected final CharacterRunAutomaton[] automata;

    public FieldOffsetStrategy(String field, BytesRef[] queryTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata) {
        this.field = field;
        this.terms = queryTerms;
        this.phraseHelper = phraseHelper;
        this.automata = automata;
    }

    public String getField() {
        return this.field;
    }

    public abstract UnifiedHighlighter.OffsetSource getOffsetSource();

    public abstract List<OffsetsEnum> getOffsetsEnums(IndexReader var1, int var2, String var3) throws IOException;

    protected List<OffsetsEnum> createOffsetsEnumsFromReader(LeafReader leafReader, int doc) throws IOException {
        Terms termsIndex = leafReader.terms(this.field);
        if (termsIndex == null) {
            return Collections.emptyList();
        }
        Map<BytesRef, Spans> strictPhrasesTermToSpans = this.phraseHelper.getTermToSpans(leafReader, doc);
        List<BytesRef> sourceTerms = this.phraseHelper.expandTermsIfRewrite(this.terms, strictPhrasesTermToSpans);
        ArrayList<OffsetsEnum> offsetsEnums = new ArrayList<OffsetsEnum>(sourceTerms.size() + this.automata.length);
        if (!sourceTerms.isEmpty()) {
            TermsEnum termsEnum = termsIndex.iterator();
            for (BytesRef term : sourceTerms) {
                if (!termsEnum.seekExact(term)) continue;
                PostingsEnum postingsEnum = termsEnum.postings(null, 56);
                if (postingsEnum == null) {
                    throw new IllegalArgumentException("field '" + this.field + "' was indexed without offsets, cannot highlight");
                }
                if (doc != postingsEnum.advance(doc) || (postingsEnum = this.phraseHelper.filterPostings(term, postingsEnum, strictPhrasesTermToSpans.get(term))) == null) continue;
                offsetsEnums.add(new OffsetsEnum(term, postingsEnum));
            }
        }
        if (this.automata.length > 0) {
            offsetsEnums.addAll(this.createAutomataOffsetsFromTerms(termsIndex, doc));
        }
        return offsetsEnums;
    }

    protected List<OffsetsEnum> createAutomataOffsetsFromTerms(Terms termsIndex, int doc) throws IOException {
        BytesRef term;
        ArrayList automataPostings = new ArrayList(this.automata.length);
        for (int i = 0; i < this.automata.length; ++i) {
            automataPostings.add(new ArrayList());
        }
        TermsEnum termsEnum = termsIndex.iterator();
        CharsRefBuilder refBuilder = new CharsRefBuilder();
        while ((term = termsEnum.next()) != null) {
            for (int i = 0; i < this.automata.length; ++i) {
                PostingsEnum postings;
                CharacterRunAutomaton automaton = this.automata[i];
                refBuilder.copyUTF8Bytes(term);
                if (!automaton.run(refBuilder.chars(), 0, refBuilder.length()) || doc != (postings = termsEnum.postings(null, 56)).advance(doc)) continue;
                ((List)automataPostings.get(i)).add(postings);
            }
        }
        ArrayList<OffsetsEnum> offsetsEnums = new ArrayList<OffsetsEnum>(this.automata.length);
        for (int i = 0; i < this.automata.length; ++i) {
            CharacterRunAutomaton automaton = this.automata[i];
            List postingsEnums = (List)automataPostings.get(i);
            int size = postingsEnums.size();
            if (size <= 0) continue;
            BytesRef wildcardTerm = new BytesRef(automaton.toString());
            if (size == 1) {
                offsetsEnums.add(new OffsetsEnum(wildcardTerm, (PostingsEnum)postingsEnums.get(0)));
                continue;
            }
            offsetsEnums.add(new OffsetsEnum(wildcardTerm, new CompositeOffsetsPostingsEnum(postingsEnums)));
        }
        return offsetsEnums;
    }
}

