/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudlink.css.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.log4j.LogManager;
import org.elasticsearch.log4j.Logger;

public class HttpUtil {
    private static Logger logger = LogManager.getLogger(HttpUtil.class);
    private static CloseableHttpClient httpClient = HttpClients.createDefault();
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_TRACE = "TRACE";

    public static void auth(String proxyHost, int port, final String account, final String password) {
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", port + "");
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(account, new String(password).toCharArray());
            }
        });
    }

    public static boolean checkConnection(String url, String auth) {
        boolean flag = false;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(5000);
            if (auth != null && !"".equals(auth)) {
                String authorization = "Basic " + new String(Base64.encodeBase64(auth.getBytes()));
                connection.setRequestProperty("Authorization", authorization);
            }
            connection.connect();
            if (connection.getResponseCode() == 200) {
                flag = true;
            }
            connection.disconnect();
        }
        catch (Exception e) {
            logger.error("--Server Connect Error !", (Throwable)e);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpRequest(String url, String method, String param, String auth) {
        String result = null;
        CloseableHttpResponse httpResponse = null;
        try {
            StringEntity body;
            HttpRequestBase http = new HttpGet(url);
            if (method.equalsIgnoreCase(METHOD_POST)) {
                http = new HttpPost(url);
                body = new StringEntity(param, ContentType.APPLICATION_JSON);
                body.setContentType("application/json");
                ((HttpPost)http).setEntity(body);
            } else if (method.equalsIgnoreCase(METHOD_PUT)) {
                http = new HttpPut(url);
                body = new StringEntity(param, ContentType.APPLICATION_JSON);
                body.setContentType("application/json");
                ((HttpPut)http).setEntity(body);
            } else if (method.equalsIgnoreCase(METHOD_DELETE)) {
                http = new HttpDelete(url);
            } else if (method.equalsIgnoreCase(METHOD_HEAD)) {
                http = new HttpHead(url);
            } else if (method.equalsIgnoreCase(METHOD_OPTIONS)) {
                http = new HttpOptions(url);
            } else if (method.equalsIgnoreCase(METHOD_TRACE)) {
                http = new HttpTrace(url);
            }
            if (auth != null && !"".equals(auth)) {
                String authorization = "Basic " + new String(Base64.encodeBase64(auth.getBytes()));
                http.setHeader("Authorization", authorization);
            }
            httpResponse = httpClient.execute(http);
            HttpEntity entity = httpResponse.getEntity();
            result = EntityUtils.toString(entity, Consts.UTF_8);
            HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
        }
        catch (Exception e) {
            logger.error("--http request error !", (Throwable)e);
            result = e.getMessage();
        }
        finally {
            HttpClientUtils.closeQuietly(httpResponse);
        }
        return result;
    }

    public static String urlRequest(String url, String method, String param, String auth) {
        String result = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(60000);
            connection.setRequestMethod(method.toUpperCase());
            if (auth != null && !"".equals(auth)) {
                String authorization = "Basic " + new String(Base64.encodeBase64(auth.getBytes()));
                connection.setRequestProperty("Authorization", authorization);
            }
            if (param != null && !"".equals(param)) {
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.connect();
                DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
                dos.write(param.getBytes(Consts.UTF_8));
                dos.flush();
                dos.close();
            } else {
                connection.connect();
            }
            if (connection.getResponseCode() == 200) {
                InputStream in = connection.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buff = new byte[1024];
                int len = 0;
                while ((len = in.read(buff, 0, buff.length)) > 0) {
                    out.write(buff, 0, len);
                }
                byte[] data = out.toByteArray();
                in.close();
                result = data != null && data.length > 0 ? new String(data, Consts.UTF_8) : null;
            } else {
                result = "{\"status\":" + connection.getResponseCode() + ",\"msg\":\"" + connection.getResponseMessage() + "\"}";
            }
            connection.disconnect();
        }
        catch (Exception e) {
            logger.error("--http request error !", (Throwable)e);
        }
        return result;
    }

    public static String encode(String target) {
        String result = target;
        try {
            result = URLEncoder.encode(target, Consts.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("--http encode error !", (Throwable)e);
        }
        return result;
    }

    public static String decode(String target) {
        String result = target;
        try {
            result = URLDecoder.decode(target, Consts.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("--http decode error !", (Throwable)e);
        }
        return result;
    }

    public static void main(String[] args) {
        String index = "testlog";
        String type = "servicelog";
        String id = "";
        String url = "http://127.0.0.1:9200/" + index + "/" + type;
        if (!"".equals(id)) {
            url = url + "/" + id;
        }
        String method = "post";
        String body = "{\"name\":\"mobile music\",\"operator\":\"10000\",\"content\":\"I like music!\",\"createTime\":\"2017-04-20\"}";
        String result = null;
        String auth = "elastic:elastic";
        result = HttpUtil.checkConnection("http://127.0.0.1:9200", auth) + "";
        result = HttpUtil.httpRequest(url, method, body, null);
        System.out.println(result);
        System.out.println("---------------------------------------------------------");
        System.out.println(result);
    }
}

