/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudlink.css.util;

import com.ucloudlink.css.util.NumberUtil;
import com.ucloudlink.css.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.elasticsearch.log4j.LogManager;
import org.elasticsearch.log4j.Logger;

public class DateUtil {
    private static Logger logger = LogManager.getLogger(DateUtil.class);
    public static final String SPLIT_DATE = "-";
    public static final String SPLIT_TIME = ":";
    public static final String DEFAULT_ISO_FORMAT_DATE_TIME = "yyyy/MM/dd HH:mm:ss";
    public static final String DEFAULT_FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_FORMAT_DATE = "yyyy-MM-dd";
    public static final String DEFAULT_FORMAT_MONTH = "yyyy-MM";
    public static final String DEFAULT_FORMAT_TIME = "HH:mm:ss";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_PATTERN_DATE_TIME = "MM-dd HH:mm";
    public static final String FORMAT_PATTERN_DATE = "MM-dd";
    public static final String FORMAT_PATTERN_TIME = "HH:mm";
    public static final String ISO_FORMAT_DATE = "MM/dd/yyyy";
    public static final String ISO_FORMAT_DATE_TIME = "MM/dd/yyyy HH:mm:ss";
    public static final String UTC_FORMAT_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final long ONE_DAY = 86400000L;

    public static Date formatDateTime(String dateTime, String format) {
        try {
            if (StringUtil.isEmpty(format)) {
                format = DEFAULT_FORMAT_DATE_TIME;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            if (dateTime != null) {
                return dateFormat.parse(dateTime);
            }
        }
        catch (Exception e) {
            logger.error("--\u65e5\u671f\u8f6c\u5316\u6307\u5b9a\u683c\u5f0f[" + format + "]\u5b57\u7b26\u4e32\u5931\u8d25!", (Throwable)e);
        }
        return null;
    }

    public static String formatDateTimeStr(Date dateTime, String format) {
        try {
            if (StringUtil.isEmpty(format)) {
                format = DEFAULT_FORMAT_DATE_TIME;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            if (dateTime != null) {
                return dateFormat.format(dateTime);
            }
        }
        catch (Exception e) {
            logger.error("--\u65e5\u671f\u8f6c\u5316\u6307\u5b9a\u683c\u5f0f[" + format + "]\u5b57\u7b26\u4e32\u5931\u8d25!", (Throwable)e);
        }
        return null;
    }

    public static Date formatDateTime(String dateTime) {
        if (StringUtil.isEmpty(dateTime)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT_DATE_TIME);
            if (NumberUtil.isNumber(dateTime)) {
                Date date = new Date(Long.parseLong(dateTime));
                dateTime = sdf.format(date);
            } else if (!dateTime.contains(SPLIT_TIME)) {
                dateTime = dateTime + " 00:00:00";
            } else if (dateTime.length() < 19) {
                dateTime = dateTime + ":00";
            }
            return sdf.parse(dateTime);
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff1a", (Throwable)e);
            return null;
        }
    }

    public static Date formatDate(String dateTime) {
        if (StringUtil.isEmpty(dateTime)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT_DATE);
            if (NumberUtil.isNumber(dateTime)) {
                Date date = new Date(Long.parseLong(dateTime));
                dateTime = sdf.format(date);
            }
            return sdf.parse(dateTime);
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff1a", (Throwable)e);
            return null;
        }
    }

    public static Date formatDate(Date dateTime) {
        String startTime = DateUtil.formatDateStr(dateTime);
        dateTime = DateUtil.formatDate(startTime);
        return dateTime;
    }

    public static String formatDateTimeStr(Date dateTime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT_DATE_TIME);
            return sdf.format(dateTime);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u5316\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String formatDateHMTimeStr(Date dateTime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE_TIME);
            return sdf.format(dateTime);
        }
        catch (Exception e) {
            logger.error("--\u65e5\u671f\u578b\u8f6c\u5b57\u7b26\u4e32(\u65e5\u671f\u683c\u5f0f[yyyy-MM-dd HH:mm])\u5931\u8d25!", (Throwable)e);
            return null;
        }
    }

    public static String formatDateStr(Date dateTime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT_DATE);
            return sdf.format(dateTime);
        }
        catch (Exception e) {
            logger.error("--\u65e5\u671f\u578b\u8f6c\u5b57\u7b26\u4e32(\u65e5\u671f\u683c\u5f0f[yyyy-MM-dd])\u5931\u8d25!", (Throwable)e);
            return null;
        }
    }

    public static String formatTimeStr(Date dateTime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT_TIME);
            return sdf.format(dateTime);
        }
        catch (Exception e) {
            logger.error("--\u65e5\u671f\u578b\u8f6c\u5b57\u7b26\u4e32(\u65e5\u671f\u683c\u5f0f[HH:mm:ss])\u5931\u8d25!", (Throwable)e);
            return null;
        }
    }

    public static String formatHMStr(Date dateTime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_PATTERN_TIME);
            return sdf.format(dateTime);
        }
        catch (Exception e) {
            logger.error("--\u65e5\u671f\u578b\u8f6c\u5b57\u7b26\u4e32(\u65e5\u671f\u683c\u5f0f[HH:mm])\u5931\u8d25!", (Throwable)e);
            return null;
        }
    }

    public static XMLGregorianCalendar getXMLCalendar(Date date) {
        DatatypeFactory datatypeFactory = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            logger.error("\u83b7\u53d6\u65f6\u95f4\u8f6c\u6362\u5de5\u5382\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        XMLGregorianCalendar datetime = datatypeFactory.newXMLGregorianCalendar(calendar);
        return datetime;
    }

    public static boolean isDateTime(String dateTime) {
        if (dateTime == null) {
            return false;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT_DATE_TIME);
            sdf.parse(dateTime);
            return true;
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u6821\u9a8c\u9519\u8bef\uff1a", (Throwable)e);
            return false;
        }
    }

    public static Date handleDateTimeByMinute(Date dateTime, int interval) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTime);
            calendar.add(12, interval);
            dateTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error("--\u95f4\u9694\u6307\u5b9a\u5206\u949f\u540e\u65e5\u671f\u5f02\u5e38!", (Throwable)e);
        }
        return dateTime;
    }

    public static Date handleDateTimeByHour(Date dateTime, int interval) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTime);
            calendar.add(10, interval);
            dateTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error("--\u95f4\u9694\u6307\u5b9a\u5c0f\u65f6\u540e\u65e5\u671f\u5f02\u5e38!", (Throwable)e);
        }
        return dateTime;
    }

    public static Date handleDateTimeByDay(Date dateTime, int interval) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTime);
            calendar.add(5, interval);
            dateTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error("--\u95f4\u9694\u6307\u5b9a\u5929\u6570\u540e\u65e5\u671f\u5f02\u5e38!", (Throwable)e);
        }
        return dateTime;
    }

    public static Date handleDateTimeByMonth(Date dateTime, int interval, int day) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTime);
            calendar.add(2, interval);
            calendar.set(5, day);
            dateTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error("--\u95f4\u9694\u6307\u5b9a\u6708\u6570\u7684\u6307\u5b9a\u5929\u6570\u540e\u65e5\u671f\u5f02\u5e38!", (Throwable)e);
        }
        return dateTime;
    }

    public static Date handleDateTimeByMonth(Date dateTime, int interval, int num, int week) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTime);
            calendar.add(2, interval);
            if (num < 0) {
                calendar.set(8, -1);
            } else {
                calendar.set(8, num);
            }
            if (week < 0) {
                calendar.set(7, 2);
            } else {
                calendar.set(7, week % 7 + 1);
            }
            dateTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error("--\u95f4\u9694\u6307\u5b9a\u6708\u6570\u7684\u6307\u5b9a\u5468\u6570\u6307\u5b9a\u661f\u671f\u6570\u540e\u65e5\u671f\u5f02\u5e38!", (Throwable)e);
        }
        return dateTime;
    }

    public static Date handleDateTimeByYear(Date dateTime, int interval, int month, int day) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTime);
            calendar.add(1, interval);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            dateTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error("--\u95f4\u9694\u6307\u5b9a\u5e74\u6570\u7684\u6307\u5b9a\u6708\u4efd\u6307\u5b9a\u5929\u6570\u540e\u65e5\u671f\u5f02\u5e38!", (Throwable)e);
        }
        return dateTime;
    }

    public static Date handleDateTimeByYear(Date dateTime, int interval, int month, int num, int week) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTime);
            calendar.add(1, interval);
            calendar.set(2, month - 1);
            if (num < 0) {
                calendar.set(8, -1);
            } else {
                calendar.set(8, num);
            }
            if (week < 0) {
                calendar.set(7, 2);
            } else {
                calendar.set(7, week % 7 + 1);
            }
            dateTime = calendar.getTime();
        }
        catch (Exception e) {
            logger.error("--\u95f4\u9694\u6307\u5b9a\u5e74\u6570\u7684\u6307\u5b9a\u6708\u4efd\u6307\u5b9a\u5468\u6570\u6307\u5b9a\u661f\u671f\u6570\u540e\u65e5\u671f\u5f02\u5e38!", (Throwable)e);
        }
        return dateTime;
    }

    public static String formatWeek(Date date) {
        String[] weeks = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7) - 1;
        if (week < 0) {
            week = 0;
        }
        return weeks[week];
    }

    public static String formatWeek(Date date, String lang) {
        String[] weeks = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        if (!StringUtil.isEmpty(lang) && (lang.contains("en") || lang.contains("EN"))) {
            weeks = new String[]{"Sun.", "Mon.", "Tues.", "Wed.", "Thur.", "Fri.", "Sat."};
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7) - 1;
        if (week < 0) {
            week = 0;
        }
        return weeks[week];
    }

    public static String formatWeek(int week, String lang) {
        String[] weeks = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        if (!StringUtil.isEmpty(lang) && (lang.contains("en") || lang.contains("EN"))) {
            weeks = new String[]{"Sun.", "Mon.", "Tues.", "Wed.", "Thur.", "Fri.", "Sat."};
        }
        if (week < 0) {
            week = 0;
        }
        return weeks[week];
    }

    public static int intervalMinutes(String from, String to) {
        try {
            Date startTime = DateUtil.formatDateTime(from);
            Date endTime = DateUtil.formatDateTime(to);
            double interval = (double)(endTime.getTime() - startTime.getTime()) / 60000.0;
            return (int)Math.floor(interval);
        }
        catch (Exception e) {
            logger.error("--\u83b7\u53d6\u65e5\u671f\u95f4\u9694\u5206\u949f\u6570\u5931\u8d25!", (Throwable)e);
            return 0;
        }
    }

    public static int intervalMinutes(Date startTime, Date endTime) {
        try {
            double interval = (double)(endTime.getTime() - startTime.getTime()) / 60000.0;
            return (int)Math.floor(interval);
        }
        catch (Exception e) {
            logger.error("--\u83b7\u53d6\u65e5\u671f\u95f4\u9694\u5206\u949f\u6570\u5931\u8d25!", (Throwable)e);
            return 0;
        }
    }

    public static int intervalHours(String from, String to) {
        try {
            Date startTime = DateUtil.formatDateTime(from);
            Date endTime = DateUtil.formatDateTime(to);
            double interval = (double)(endTime.getTime() - startTime.getTime()) / 3600000.0;
            return (int)Math.floor(interval);
        }
        catch (Exception e) {
            logger.error("--\u83b7\u53d6\u65e5\u671f\u95f4\u9694\u5c0f\u65f6\u6570\u5931\u8d25!", (Throwable)e);
            return 0;
        }
    }

    public static int intervalHours(Date start, Date end) {
        try {
            double interval = (double)(end.getTime() - start.getTime()) / 3600000.0;
            return (int)Math.floor(interval);
        }
        catch (Exception e) {
            logger.error("--\u83b7\u53d6\u65e5\u671f\u95f4\u9694\u5c0f\u65f6\u6570\u5931\u8d25!", (Throwable)e);
            return 0;
        }
    }

    public static int intervalDays(String from, String to) {
        try {
            Date startTime = DateUtil.formatDateTime(from);
            Date endTime = DateUtil.formatDateTime(to);
            double interval = (double)(endTime.getTime() - startTime.getTime()) / 8.64E7;
            return (int)Math.ceil(interval);
        }
        catch (Exception e) {
            logger.error("--\u83b7\u53d6\u65e5\u671f\u95f4\u9694\u5929\u6570\u5931\u8d25!", (Throwable)e);
            return 0;
        }
    }

    public static int intervalDays(Date start, Date end) {
        try {
            double interval = (double)(end.getTime() - start.getTime()) / 8.64E7;
            return (int)Math.ceil(interval);
        }
        catch (Exception e) {
            logger.error("--\u83b7\u53d6\u65e5\u671f\u95f4\u9694\u5929\u6570\u5931\u8d25!", (Throwable)e);
            return 0;
        }
    }

    public static int intervalMonths(Date start, Date end) {
        try {
            int interval = (Integer.valueOf(DateUtil.formatYear(end)) - Integer.valueOf(DateUtil.formatYear(start))) * 12 + (Integer.valueOf(DateUtil.formatMonth(end)) - Integer.valueOf(DateUtil.formatMonth(start)));
            return interval;
        }
        catch (Exception e) {
            logger.error("--\u83b7\u53d6\u65e5\u671f\u95f4\u9694\u6708\u6570\u5931\u8d25!", (Throwable)e);
            return 0;
        }
    }

    public static String formatDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd");
        String ctime = formatter.format(date);
        return ctime;
    }

    public static String formatMonth(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM");
        String ctime = formatter.format(date);
        return ctime;
    }

    public static String formatYear(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        String ctime = formatter.format(date);
        return ctime;
    }

    public static Date formatFirstTime(Date date) {
        String dateTime = DateUtil.formatDateStr(date) + " 00:00:00";
        date = DateUtil.formatDateTime(dateTime);
        return date;
    }

    public static Date formatLastTime(Date date) {
        String dateTime = DateUtil.formatDateStr(date) + " 23:59:59";
        return DateUtil.formatDateTime(dateTime);
    }

    public static Date formatWeekFirstTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 1);
        String dateTime = DateUtil.formatDateStr(calendar.getTime()) + " 00:00:00";
        date = DateUtil.formatDateTime(dateTime);
        return date;
    }

    public static Date formatWeekLastTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 7);
        String dateTime = DateUtil.formatDateStr(calendar.getTime()) + " 23:59:59";
        return DateUtil.formatDateTime(dateTime);
    }

    public static Date formatMonthFirstTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        String dateTime = DateUtil.formatDateStr(calendar.getTime()) + " 00:00:00";
        date = DateUtil.formatDateTime(dateTime);
        return date;
    }

    public static Date formatMonthLastTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        date.setTime(calendar.getTimeInMillis() - 86400000L);
        String dateTime = DateUtil.formatDateStr(date) + " 23:59:59";
        return DateUtil.formatDateTime(dateTime);
    }

    public static Date formatYearFirstTime(Date date) {
        String dateTime = DateUtil.formatYear(date) + "-01-01 00:00:00";
        return DateUtil.formatDateTime(dateTime);
    }

    public static Date formatYearLastTime(Date date) {
        String dateTime = DateUtil.formatYear(date) + "-12-31 23:59:59";
        return DateUtil.formatDateTime(dateTime);
    }

    public static String formatChinaDate(Date date) {
        String format = "yyyy\u5e74MM\u6708dd\u65e5";
        return DateUtil.formatDateTimeStr(date, format);
    }

    public static String formatUTCDateTime(Date date, String format) {
        if (StringUtil.isEmpty(format)) {
            format = UTC_FORMAT_DATE_TIME;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(zoneOffset + dstOffset));
        return DateUtil.formatDateTimeStr(calendar.getTime(), format);
    }

    public static String formatRangeDateTime(Date start, Date end, boolean showTime) {
        String startTime = DateUtil.formatDateTimeStr(start, DEFAULT_FORMAT_DATE);
        String endTime = DateUtil.formatDateTimeStr(end, DEFAULT_FORMAT_DATE);
        if (!showTime) {
            if (DateUtil.formatYear(start) == DateUtil.formatYear(end)) {
                if (startTime == endTime) {
                    return startTime;
                }
                return startTime + " ~ " + DateUtil.formatDateTimeStr(end, FORMAT_PATTERN_DATE);
            }
            return startTime + " ~ " + endTime;
        }
        if (startTime == endTime) {
            return DateUtil.formatDateTimeStr(start, FORMAT_DATE_TIME) + " ~ " + DateUtil.formatDateTimeStr(end, FORMAT_PATTERN_TIME);
        }
        if (DateUtil.formatYear(start) == DateUtil.formatYear(end)) {
            return DateUtil.formatDateTimeStr(start, FORMAT_DATE_TIME) + " ~ " + DateUtil.formatDateTimeStr(end, FORMAT_PATTERN_DATE_TIME);
        }
        return DateUtil.formatDateTimeStr(start, FORMAT_DATE_TIME) + " ~ " + DateUtil.formatDateTimeStr(end, FORMAT_DATE_TIME);
    }

    public static String formatRangeDateStr(Date start, Date end) {
        String rangeTime = DateUtil.formatDateTimeStr(start, "MM\u6708dd\u65e5");
        rangeTime = rangeTime + " " + DateUtil.formatDateTimeStr(start, FORMAT_PATTERN_TIME);
        rangeTime = rangeTime + "~" + DateUtil.formatDateTimeStr(end, FORMAT_PATTERN_TIME);
        return rangeTime;
    }

    public static String formatRangeDateStrEng(Date start, Date end) {
        String rangeTime = DateUtil.formatDateTimeStr(start, DEFAULT_FORMAT_DATE);
        rangeTime = rangeTime + " " + DateUtil.formatDateTimeStr(start, FORMAT_PATTERN_TIME);
        rangeTime = rangeTime + "~" + DateUtil.formatDateTimeStr(end, FORMAT_PATTERN_TIME);
        return rangeTime;
    }

    public static void main(String[] args) {
        String CHINA_FORMAT_DATE_TIME = "G yyyy\u5e74MM\u6708dd\u65e5 a HH\u65f6mm\u5206ss\u79d2SSS\u6beb\u79d2 zZ(\u672c\u5e74\u7b2cw\u5468,\u672c\u6708\u7b2cW\u5468,\u672c\u5e74\u7b2cD\u5929,\u672c\u6708\u7b2cF\u661f\u671f\u7684E)";
        String dateTime = DateUtil.formatDateTimeStr(DateUtil.formatDateTime("2016-07-31 13:26:50"), CHINA_FORMAT_DATE_TIME);
        System.out.println(dateTime);
        Date today = new Date();
        System.out.println(DateUtil.formatFirstTime(today));
        System.out.println(DateUtil.formatLastTime(today));
        System.out.println(DateUtil.formatWeekFirstTime(today));
        System.out.println(DateUtil.formatWeekLastTime(today));
        System.out.println(DateUtil.formatMonthFirstTime(today));
        System.out.println(DateUtil.formatMonthLastTime(today));
        Date start = DateUtil.formatDate("2016-11-01");
        Date end = DateUtil.formatDate("2016-11-23");
        System.out.println(DateUtil.intervalMonths(start, end));
    }
}

