/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudlink.css.elasticsearch;

import com.ucloudlink.css.elasticsearch.ElasticsearchFactory;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.fastjson.JSON;
import org.elasticsearch.fastjson.JSONObject;

public abstract class AbstractElasticsearchFactory
implements ElasticsearchFactory {
    protected static String regex = "[-,:,/\"]";
    protected String clusterName = "elasticsearch";
    protected String servers = "localhost";
    protected String username;
    protected String password;
    protected int port;

    public abstract int defaultPort();

    public abstract String mapping(String var1, String var2, Class var3);

    public AbstractElasticsearchFactory() {
        this.port = this.defaultPort();
    }

    public AbstractElasticsearchFactory(String servers) {
        this.servers = servers;
        this.port = this.defaultPort();
    }

    public AbstractElasticsearchFactory(String servers, int port) {
        this.servers = servers;
        this.port = port > 0 ? port : this.defaultPort();
    }

    public AbstractElasticsearchFactory(String clusterName, String servers, int port) {
        this.clusterName = clusterName;
        this.servers = servers;
        this.port = port > 0 ? port : this.defaultPort();
    }

    public AbstractElasticsearchFactory(String clusterName, String servers, String username, String password) {
        this.clusterName = clusterName;
        this.servers = servers;
        this.username = username;
        this.password = password;
        this.port = this.defaultPort();
    }

    public AbstractElasticsearchFactory(String clusterName, String servers, String username, String password, int port) {
        this.clusterName = clusterName;
        this.servers = servers;
        this.username = username;
        this.password = password;
        this.port = port > 0 ? port : this.defaultPort();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected Map<String, Object> reflect(Class clazz, boolean isCustom) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String mapping;
            String name = field.getName();
            if (name.equalsIgnoreCase("serialVersionUID")) continue;
            String type = field.getType().getSimpleName();
            if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("Integer")) {
                mapping = "{type: 'integer',index:'not_analyzed'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("byte")) {
                mapping = "{type: 'byte',index:'not_analyzed'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("short")) {
                mapping = "{type: 'short',index:'not_analyzed'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("long")) {
                mapping = "{type: 'long',index:'not_analyzed'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("boolean")) {
                mapping = "{type: 'boolean',index:'not_analyzed'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("float")) {
                mapping = "{type: 'float',index:'not_analyzed'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("double")) {
                mapping = "{type: 'double',index:'not_analyzed'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("date") || type.equalsIgnoreCase("datetime")) {
                String format = "strict_date_optional_time||epoch_millis";
                format = format + "||basic_date||basic_date_time||basic_date_time_no_millis";
                format = format + "||basic_time||basic_time_no_millis||basic_t_time||basic_t_time_no_millis";
                format = format + "||strict_basic_week_date||strict_basic_week_date_time_no_millis";
                format = format + "||strict_date||strict_date_hour_minute||strict_date_hour_minute_second||strict_date_hour_minute_second_fraction||strict_date_hour_minute_second_millis";
                format = format + "||strict_date_time||strict_date_time_no_millis";
                format = format + "||strict_hour_minute||strict_hour_minute_second||strict_hour_minute_second_fraction||strict_hour_minute_second_millis";
                format = format + "||strict_time||strict_time_no_millis||strict_t_time||strict_t_time_no_millis";
                format = format + "||strict_week_date||strict_week_date_time||strict_week_date_time_no_millis";
                format = format + "||strict_year_month_day";
                format = format + "||yyyy-MM-dd||yyyy-MM-dd HH:mm:ss";
                String mapping2 = "{type: 'date',index:'not_analyzed',format:'" + format + "'}";
                map.put(name, JSON.parseObject(mapping2));
                continue;
            }
            if (type.equalsIgnoreCase("char") || type.equalsIgnoreCase("Character")) {
                mapping = "{type: 'string',index:'not_analyzed'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("object")) {
                mapping = "{type: 'object'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("String[]")) {
                mapping = "{type: 'text'}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            if (type.equalsIgnoreCase("string")) {
                mapping = "{type: 'string',index:'analyzed',fields:{en:{type:'string',analyzer:'english'},keyword:{type:'keyword',ignore_above:256}" + (isCustom ? ",custom:{type:'string',analyzer:'es_analyzer'}" : "") + "}}";
                map.put(name, JSON.parseObject(mapping));
                continue;
            }
            mapping = "{properties: " + JSON.toJSONString(this.reflect(field.getDeclaringClass(), isCustom)) + "}";
            map.put(name, JSON.parseObject(mapping));
        }
        return map;
    }

    protected JSONObject analyzer(String index) {
        String char_filter = "{symbol_transform:{type:'mapping',mappings:['&=> and ','||=> or ']}}";
        String filter = "{default_stopwords:{type:'stop',stopwords:['a','an','and','are','as','at','be','but','by','for','if','in','into','is','it','no','not','of','on','or','such','that','the','their','then','there','these','they','this','to','was','will','with']}}";
        String analyzer = "{es_analyzer:{type:'custom',char_filter:['html_strip','symbol_transform'],tokenizer:'standard',filter:['lowercase','default_stopwords']}}";
        String settings = "{settings:{analysis:{char_filter:" + JSON.parseObject(char_filter).toJSONString() + ",filter:" + JSON.parseObject(filter).toJSONString() + ",analyzer:" + JSON.parseObject(analyzer).toJSONString() + "}}}";
        return JSON.parseObject(settings);
    }
}

