/*
 * Decompiled with CFR 0.152.
 */
package com.twolight.android.permission;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.support.annotation.NonNull;
import com.twolight.android.permission.PermissionFragment;
import com.twolight.android.permission.PermissionListener;

public class PermissionUtil {
    private static final String TAG = "PermissionUtil";
    private PermissionFragment mRxPermissionsFragment;

    public static PermissionUtil with(Activity activity) {
        return new PermissionUtil(activity);
    }

    PermissionUtil(@NonNull Activity activity) {
        this.mRxPermissionsFragment = this.getPermissionsFragment(activity);
    }

    private PermissionFragment getPermissionsFragment(Activity activity) {
        boolean isNewInstance;
        PermissionFragment permissionsFragment = this.findRxPermissionsFragment(activity);
        boolean bl = isNewInstance = permissionsFragment == null;
        if (isNewInstance) {
            permissionsFragment = new PermissionFragment();
            FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager.beginTransaction().add((Fragment)permissionsFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return permissionsFragment;
    }

    private PermissionFragment findRxPermissionsFragment(Activity activity) {
        return (PermissionFragment)activity.getFragmentManager().findFragmentByTag(TAG);
    }

    public void requestPermission(String[] permission2, int requestCode, PermissionListener permissionListener) {
        this.mRxPermissionsFragment.requestPermission(permission2, requestCode, permissionListener);
    }
}

