package com.twolight.android.permission;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by twolight on 17/4/17.
 */

public class PermissionFragment extends Fragment {

    private PermissionListener mPermissionListener;

    public PermissionFragment() {

    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
    }


    @Override
    @TargetApi(Build.VERSION_CODES.M)
    public void onRequestPermissionsResult(int requestCode, @NonNull String permissions[], @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        checkPermission(requestCode,permissions,grantResults);
    }

    private void checkPermission(int requestCode,String[] permissions, int[] grantResults) {
        if(permissions.length > 0 && grantResults.length > 0){
            boolean allGranted = true;
            for(int item : grantResults){
                if(item != PackageManager.PERMISSION_GRANTED){
                    allGranted = false;
                    break;
                }
            }
            onPermissionResult(allGranted,requestCode);
        }
    }

    public void onPermissionResult(boolean success,int requestCode){
        mPermissionListener.onPermissionResult(success,requestCode);
        mPermissionListener = null;
    }


    public void requestPermission(String[] permission, int requestCode, PermissionListener permissionListener){
        mPermissionListener = permissionListener;
        if(Build.VERSION.SDK_INT >= 23){
            List<String> inDangerousPermissions = filterPermission(permission);

            ArrayList<String> noGranted = new ArrayList<>();

            for(String item : inDangerousPermissions){
                int result = ContextCompat.checkSelfPermission(getActivity(), item);
                if (result != PackageManager.PERMISSION_GRANTED) {
                    noGranted.add(item);
                }
            }
            if (!noGranted.isEmpty()) {
                String[] will = new String[noGranted.size()];
                noGranted.toArray(will);

                boolean needShowMessage = false;

                for (String p : will){
                    if(ActivityCompat.shouldShowRequestPermissionRationale(getActivity(),p)){
                        needShowMessage = true;
                        break;
                    }
                }

                if(needShowMessage){
//                    baseView.showToast("分享需要授权");
                    permissionListener.onShowNotifyMessage();
                }

                requestPermissions(will , requestCode);
                return;
            }
        }
        permissionListener.onPermissionResult(true,requestCode);
    }


    private static List<String> filterPermission(String[] permission){
        List<String> inDangerousPermissions = new ArrayList<>();

        List<String> dangerousPermissions =  new ArrayList<>();

        dangerousPermissions.add(Manifest.permission.WRITE_CONTACTS);
        dangerousPermissions.add(Manifest.permission.GET_ACCOUNTS);
        dangerousPermissions.add(Manifest.permission.READ_CONTACTS);

        dangerousPermissions.add(Manifest.permission.READ_CALL_LOG);
        dangerousPermissions.add(Manifest.permission.READ_PHONE_STATE);
        dangerousPermissions.add(Manifest.permission.READ_PHONE_STATE);
        dangerousPermissions.add(Manifest.permission.CALL_PHONE);
        dangerousPermissions.add(Manifest.permission.WRITE_CALL_LOG);
        dangerousPermissions.add(Manifest.permission.USE_SIP);
        dangerousPermissions.add(Manifest.permission.PROCESS_OUTGOING_CALLS);
        dangerousPermissions.add(Manifest.permission.ADD_VOICEMAIL);

        dangerousPermissions.add(Manifest.permission.READ_CALENDAR);
        dangerousPermissions.add(Manifest.permission.WRITE_CALENDAR);

        dangerousPermissions.add(Manifest.permission.CAMERA);

        dangerousPermissions.add(Manifest.permission.BODY_SENSORS);

        dangerousPermissions.add(Manifest.permission.ACCESS_FINE_LOCATION);
        dangerousPermissions.add(Manifest.permission.ACCESS_COARSE_LOCATION);

        dangerousPermissions.add(Manifest.permission.READ_EXTERNAL_STORAGE);
        dangerousPermissions.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);

        dangerousPermissions.add(Manifest.permission.RECORD_AUDIO);

        dangerousPermissions.add(Manifest.permission.READ_SMS);
        dangerousPermissions.add(Manifest.permission.RECEIVE_WAP_PUSH);
        dangerousPermissions.add(Manifest.permission.RECEIVE_MMS);
        dangerousPermissions.add(Manifest.permission.RECEIVE_SMS);
        dangerousPermissions.add(Manifest.permission.SEND_SMS);

        for (String p : permission){
            if(dangerousPermissions.contains(p)){
                inDangerousPermissions.add(p);
            }
        }
        return inDangerousPermissions;
    }
}

