/*
 * Decompiled with CFR 0.152.
 */
package com.twolight.android.loader;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.widget.ImageView;
import com.bumptech.glide.DrawableTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.util.Util;
import com.twolight.android.loader.transformation.BlurTransformation;
import com.twolight.android.loader.transformation.CropCircleTransformation;
import com.twolight.android.loader.transformation.RoundedCornersTransformation;
import java.io.File;

public class ImageLoader {
    public static Build with(Context context) {
        return new Build(context);
    }

    public static Build with(Fragment fragment) {
        return new Build(fragment.getContext());
    }

    public static Build with(Activity activity) {
        return new Build((Context)activity);
    }

    public static void pauseRequests(Context context) {
        if (Util.isOnMainThread()) {
            Glide.with((Context)context.getApplicationContext()).pauseRequests();
        }
    }

    public static void resumeRequests(Context context) {
        if (Util.isOnMainThread()) {
            Glide.with((Context)context.getApplicationContext()).resumeRequests();
        }
    }

    public static enum Config {
        ALPHA_8(0),
        RGB_565(1);

        final int nativeInt;

        private Config(int i) {
            this.nativeInt = i;
        }
    }

    public static class Blur {
        private int mRadius;
        private int mSampling;

        public Blur(int radius, int sampling) {
            this.mRadius = radius;
            this.mSampling = sampling;
        }
    }

    public static class Build {
        private Context mContext;
        private File mFile;
        private String mUrl;
        private Uri mUri;
        @DrawableRes
        private Integer mRes;
        private Blur mBlur;
        private Integer mCorner;
        private Config mConfig;
        private boolean mCircle;
        @DrawableRes
        private Integer mPlaceHolderRes;
        @DrawableRes
        private Integer mErrorRes;

        public Build(Context context) {
            this.mContext = context;
        }

        public Build load(File file) {
            this.mFile = file;
            return this;
        }

        public Build load(String url) {
            this.mUrl = url;
            return this;
        }

        public Build load(Uri uri) {
            this.mUri = uri;
            return this;
        }

        public Build load(@DrawableRes Integer res) {
            this.mRes = res;
            return this;
        }

        public Build error(@DrawableRes Integer res) {
            this.mErrorRes = res;
            return this;
        }

        public Build placeholder(@DrawableRes Integer res) {
            this.mPlaceHolderRes = res;
            return this;
        }

        public Build blur(Blur blur) {
            this.mBlur = blur;
            return this;
        }

        public Build roundCorner(int roundCorner) {
            this.mCorner = roundCorner;
            return this;
        }

        public Build circle(boolean circle) {
            this.mCircle = circle;
            return this;
        }

        public Build reSize(int width, int height) {
            return this;
        }

        public Build format(Config config) {
            this.mConfig = config;
            return this;
        }

        public void into(ImageView imageView) {
            DrawableTypeRequest drawableTypeRequest;
            if (this.mContext == null || imageView == null) {
                return;
            }
            RequestManager requestManager = Glide.with((Context)this.mContext);
            if (this.mFile != null) {
                drawableTypeRequest = requestManager.load(this.mFile);
            } else if (this.mUrl != null) {
                drawableTypeRequest = requestManager.load(this.mUrl);
            } else if (this.mUri != null) {
                drawableTypeRequest = requestManager.load(this.mUri);
            } else if (this.mRes != null) {
                drawableTypeRequest = requestManager.load(this.mRes);
            } else {
                return;
            }
            if (this.mBlur != null) {
                drawableTypeRequest.bitmapTransform(new Transformation[]{new BlurTransformation(this.mContext, this.mBlur.mRadius, this.mBlur.mSampling)});
            }
            if (this.mCorner != null) {
                drawableTypeRequest.bitmapTransform(new Transformation[]{new RoundedCornersTransformation(this.mContext, (int)this.mCorner, 0)});
            }
            if (this.mCircle) {
                drawableTypeRequest.bitmapTransform(new Transformation[]{new CropCircleTransformation(this.mContext)});
            }
            if (this.mPlaceHolderRes != null) {
                drawableTypeRequest.placeholder(this.mPlaceHolderRes.intValue());
            }
            if (this.mErrorRes != null) {
                drawableTypeRequest.error(this.mErrorRes.intValue());
            }
            drawableTypeRequest.dontAnimate();
            if (this.mConfig != null && this.mConfig == Config.ALPHA_8) {
                drawableTypeRequest.asBitmap().format(DecodeFormat.PREFER_ARGB_8888).asIs().override(Integer.MIN_VALUE, Integer.MIN_VALUE).into(imageView);
                return;
            }
            drawableTypeRequest.diskCacheStrategy(DiskCacheStrategy.SOURCE).into(imageView);
        }
    }
}

