/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.twitter.finagle.stats.CumulativeGauge;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.MetricBuilder;
import com.twitter.finagle.stats.MetricBuilder$GaugeType$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.StatsReceiverWithCumulativeGauges$;
import com.twitter.finagle.stats.StatsReceiverWithCumulativeGauges$$anon$3$;
import com.twitter.util.lint.Category;
import com.twitter.util.lint.Issue$;
import com.twitter.util.lint.Rule;
import com.twitter.util.lint.Rule$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.LambdaDeserialize;

public interface StatsReceiverWithCumulativeGauges
extends StatsReceiver {
    public static void $init$(StatsReceiverWithCumulativeGauges $this) {
        $this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_setter_$com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges_$eq(new ConcurrentHashMap());
    }

    public ConcurrentHashMap<Seq<String>, CumulativeGauge> com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges();

    public void com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_setter_$com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges_$eq(ConcurrentHashMap var1);

    public static Rule largeGaugeLinterRule$(StatsReceiverWithCumulativeGauges $this) {
        return $this.largeGaugeLinterRule();
    }

    default public Rule largeGaugeLinterRule() {
        return Rule$.MODULE$.apply((Category)Category.Performance$.MODULE$, "Large CumulativeGauges", "Identifies CumulativeGauges which are backed by very large numbers (10k+) of Gauges. Indicative of a leak or code registering the same gauge more " + ("often than expected. (For " + this.toString() + ")"), this::largeGaugeLinterRule$$anonfun$1);
    }

    public void registerGauge(MetricBuilder var1, Function0 var2);

    public void deregisterGauge(MetricBuilder var1);

    private Function<Seq<String>, CumulativeGauge> getWhenNotPresent(MetricBuilder metricBuilder) {
        return this.whenNotPresent(metricBuilder);
    }

    public static Executor executor$(StatsReceiverWithCumulativeGauges $this) {
        return $this.executor();
    }

    default public Executor executor() {
        return ForkJoinPool.commonPool();
    }

    private Function<Seq<String>, CumulativeGauge> whenNotPresent(MetricBuilder metricBuilder) {
        return new Function<Seq<String>, CumulativeGauge>(metricBuilder, this){
            public final MetricBuilder com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$1$$metricBuilder$1;
            private final StatsReceiverWithCumulativeGauges $outer;
            {
                this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$1$$metricBuilder$1 = metricBuilder$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public CumulativeGauge apply(Seq key) {
                return new CumulativeGauge(this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$1$$metricBuilder$1, key, this){
                    private final Seq key$1;
                    private final AtomicInteger registers;
                    private final $anon$1 $outer;
                    {
                        this.key$1 = key$1;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$1$$_$$anon$superArg$1$1());
                        $outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_$$anon$$$outer().registerGauge(metricBuilder$2, this::$init$$$anonfun$1);
                        this.registers = new AtomicInteger(0);
                    }

                    public boolean register() {
                        boolean bl;
                        block1: {
                            int c;
                            $anon$3$$anon$1 var1_1 = this;
                            do {
                                if ((c = var1_1.registers.get()) != -1) continue;
                                bl = false;
                                break block1;
                            } while (!var1_1.registers.compareAndSet(c, c + 1));
                            bl = true;
                        }
                        return bl;
                    }

                    public void deregister() {
                        int n;
                        $anon$3$$anon$1 var1_1 = this;
                        while (-1 != (n = var1_1.registers.get())) {
                            if (1 == n) {
                                if (!var1_1.registers.compareAndSet(1, -1)) continue;
                                var1_1.$outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_$$anon$$$outer().com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().remove(this.key$1);
                                var1_1.$outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_$$anon$$$outer().deregisterGauge(this.$outer.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$1$$metricBuilder$1);
                                break;
                            }
                            int c = n;
                            if (!var1_1.registers.compareAndSet(c, c - 1)) continue;
                        }
                    }

                    private final float $init$$$anonfun$1() {
                        return this.getValue();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$1()}, serializedLambda);
                    }
                };
            }

            public final StatsReceiverWithCumulativeGauges com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$_$$anon$$$outer() {
                return this.$outer;
            }

            public final Executor com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$anon$1$$_$$anon$superArg$1$1() {
                return this.$outer.executor();
            }
        };
    }

    public static Gauge addGauge$(StatsReceiverWithCumulativeGauges $this, MetricBuilder metricBuilder, Function0 f) {
        return $this.addGauge(metricBuilder, f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public Gauge addGauge(MetricBuilder metricBuilder, Function0 f) {
        void var3_3;
        this.validateMetricType(metricBuilder, MetricBuilder$GaugeType$.MODULE$);
        Gauge gauge = null;
        while (gauge == null) {
            CumulativeGauge cumulativeGauge = this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().computeIfAbsent(metricBuilder.name(), this.getWhenNotPresent(metricBuilder));
            gauge = cumulativeGauge.addGauge(f, metricBuilder);
        }
        return var3_3;
    }

    public static int numUnderlying$(StatsReceiverWithCumulativeGauges $this, Seq name) {
        return $this.numUnderlying((Seq<String>)name);
    }

    default public int numUnderlying(Seq<String> name) {
        CumulativeGauge cumulativeGauge = this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges().get(name);
        return cumulativeGauge == null ? 0 : cumulativeGauge.size();
    }

    private Seq largeGaugeLinterRule$$anonfun$1() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.com$twitter$finagle$stats$StatsReceiverWithCumulativeGauges$$gauges()).asScala().collect((PartialFunction)new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 == null) return false;
                Seq ks = (Seq)tuple2._1();
                CumulativeGauge cg = (CumulativeGauge)tuple2._2();
                if (cg.totalSize() < 10000) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Object object;
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Seq ks = (Seq)tuple2._1();
                    CumulativeGauge cg = (CumulativeGauge)tuple2._2();
                    if (cg.totalSize() >= 10000) {
                        object = Issue$.MODULE$.apply(ks.mkString("/") + "=" + cg.totalSize());
                        return object;
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        })).toSeq();
    }
}

