/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Metadata;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import scala.Function0;

public abstract class CumulativeGauge {
    private final Cache<UnderlyingGauge, Boolean> refs;

    public CumulativeGauge(Executor executor) {
        RemovalListener<UnderlyingGauge, Boolean> removals = new RemovalListener<UnderlyingGauge, Boolean>(this){
            private final CumulativeGauge $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onRemoval(UnderlyingGauge key, Boolean value, RemovalCause cause) {
                this.$outer.deregister();
            }
        };
        this.refs = Caffeine.newBuilder().executor(executor).weakKeys().removalListener((RemovalListener)removals).build();
    }

    public CumulativeGauge() {
        this(ForkJoinPool.commonPool());
    }

    public void cleanup() {
        this.refs.cleanUp();
    }

    public int size() {
        this.cleanup();
        return this.totalSize();
    }

    public int totalSize() {
        return (int)this.refs.estimatedSize();
    }

    public void com$twitter$finagle$stats$CumulativeGauge$$remove(UnderlyingGauge underlyingGauge) {
        this.refs.invalidate((Object)underlyingGauge);
    }

    public Gauge addGauge(Function0 f, Metadata metadata) {
        UnderlyingGauge underlyingGauge = new UnderlyingGauge(this, (Function0<Object>)(Function0 & Serializable)() -> f.apply$mcF$sp(), metadata);
        this.refs.put((Object)underlyingGauge, (Object)Boolean.TRUE);
        return this.register() ? underlyingGauge : null;
    }

    /*
     * WARNING - void declaration
     */
    public float getValue() {
        void var1_1;
        float sum = 0.0f;
        for (UnderlyingGauge g : this.refs.asMap().keySet()) {
            sum += g.f().apply$mcF$sp();
        }
        return (float)var1_1;
    }

    public abstract boolean register();

    public abstract void deregister();

    private class UnderlyingGauge
    implements Gauge {
        private final Function0 f;
        private final Metadata metadata;
        private final CumulativeGauge $outer;

        public UnderlyingGauge(CumulativeGauge $outer, Function0<Object> f, Metadata metadata) {
            this.f = f;
            this.metadata = metadata;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Function0<Object> f() {
            return this.f;
        }

        @Override
        public Metadata metadata() {
            return this.metadata;
        }

        @Override
        public void remove() {
            this.$outer.com$twitter$finagle$stats$CumulativeGauge$$remove(this);
        }

        public final CumulativeGauge com$twitter$finagle$stats$CumulativeGauge$UnderlyingGauge$$$outer() {
            return this.$outer;
        }
    }
}

