/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.logging;

import com.twitter.util.logging.Logger$;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;

public final class Logger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final org.slf4j.Logger underlying;

    public static Logger apply(Class<?> clazz) {
        return Logger$.MODULE$.apply(clazz);
    }

    public static <T> Logger apply(ClassTag<T> classTag) {
        return Logger$.MODULE$.apply(classTag);
    }

    public static Logger apply(org.slf4j.Logger logger) {
        return Logger$.MODULE$.apply(logger);
    }

    public static Logger apply(String string) {
        return Logger$.MODULE$.apply(string);
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger$.MODULE$.getLogger(clazz);
    }

    public static Logger getLogger(org.slf4j.Logger logger) {
        return Logger$.MODULE$.getLogger(logger);
    }

    public static Logger getLogger(String string) {
        return Logger$.MODULE$.getLogger(string);
    }

    public Logger(org.slf4j.Logger underlying) {
        this.underlying = underlying;
    }

    public String name() {
        return this.underlying.getName();
    }

    public boolean isTraceEnabled() {
        return this.underlying.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.underlying.isTraceEnabled(marker);
    }

    public void trace(String message) {
        if (this.underlying.isTraceEnabled()) {
            this.underlying.trace(message);
        }
    }

    public void trace(String message, Throwable cause) {
        if (this.underlying.isTraceEnabled()) {
            this.underlying.trace(message, cause);
        }
    }

    public void trace(Marker marker, String message) {
        if (this.underlying.isTraceEnabled(marker)) {
            this.underlying.trace(marker, message);
        }
    }

    public void trace(Marker marker, String message, Throwable cause) {
        if (this.underlying.isTraceEnabled(marker)) {
            this.underlying.trace(marker, message, cause);
        }
    }

    public void traceWith(String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isTraceEnabled()) {
                this.underlying.trace(message);
            }
        } else if (this.underlying.isTraceEnabled()) {
            this.underlying.trace(message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public void traceWith(Marker marker, String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isTraceEnabled(marker)) {
                this.underlying.trace(marker, message);
            }
        } else if (this.underlying.isTraceEnabled(marker)) {
            this.underlying.trace(marker, message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public boolean isDebugEnabled() {
        return this.underlying.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.underlying.isDebugEnabled(marker);
    }

    public void debug(String message) {
        if (this.underlying.isDebugEnabled()) {
            this.underlying.debug(message);
        }
    }

    public void debug(String message, Throwable cause) {
        if (this.underlying.isDebugEnabled()) {
            this.underlying.debug(message, cause);
        }
    }

    public void debug(Marker marker, String message) {
        if (this.underlying.isDebugEnabled(marker)) {
            this.underlying.debug(marker, message);
        }
    }

    public void debug(Marker marker, String message, Throwable cause) {
        if (this.underlying.isDebugEnabled(marker)) {
            this.underlying.debug(marker, message, cause);
        }
    }

    public void debugWith(String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isDebugEnabled()) {
                this.underlying.debug(message);
            }
        } else if (this.underlying.isDebugEnabled()) {
            this.underlying.debug(message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public void debugWith(Marker marker, String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isDebugEnabled(marker)) {
                this.underlying.debug(marker, message);
            }
        } else if (this.underlying.isDebugEnabled(marker)) {
            this.underlying.debug(marker, message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public boolean isInfoEnabled() {
        return this.underlying.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.underlying.isInfoEnabled(marker);
    }

    public void info(String message) {
        if (this.underlying.isInfoEnabled()) {
            this.underlying.info(message);
        }
    }

    public void info(String message, Throwable cause) {
        if (this.underlying.isInfoEnabled()) {
            this.underlying.info(message, cause);
        }
    }

    public void info(Marker marker, String message) {
        if (this.underlying.isInfoEnabled(marker)) {
            this.underlying.info(marker, message);
        }
    }

    public void info(Marker marker, String message, Throwable cause) {
        if (this.underlying.isInfoEnabled(marker)) {
            this.underlying.info(marker, message, cause);
        }
    }

    public void infoWith(String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isInfoEnabled()) {
                this.underlying.info(message);
            }
        } else if (this.underlying.isInfoEnabled()) {
            this.underlying.info(message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public void infoWith(Marker marker, String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isInfoEnabled(marker)) {
                this.underlying.info(marker, message);
            }
        } else if (this.underlying.isInfoEnabled(marker)) {
            this.underlying.info(marker, message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public boolean isWarnEnabled() {
        return this.underlying.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.underlying.isWarnEnabled(marker);
    }

    public void warn(String message) {
        if (this.underlying.isWarnEnabled()) {
            this.underlying.warn(message);
        }
    }

    public void warn(String message, Throwable cause) {
        if (this.underlying.isWarnEnabled()) {
            this.underlying.warn(message, cause);
        }
    }

    public void warn(Marker marker, String message) {
        if (this.underlying.isWarnEnabled(marker)) {
            this.underlying.warn(marker, message);
        }
    }

    public void warn(Marker marker, String message, Throwable cause) {
        if (this.underlying.isWarnEnabled(marker)) {
            this.underlying.warn(marker, message, cause);
        }
    }

    public void warnWith(String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isWarnEnabled()) {
                this.underlying.warn(message);
            }
        } else if (this.underlying.isWarnEnabled()) {
            this.underlying.warn(message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public void warnWith(Marker marker, String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isWarnEnabled(marker)) {
                this.underlying.warn(marker, message);
            }
        } else if (this.underlying.isWarnEnabled(marker)) {
            this.underlying.warn(marker, message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public boolean isErrorEnabled() {
        return this.underlying.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.underlying.isErrorEnabled(marker);
    }

    public void error(String message) {
        if (this.underlying.isErrorEnabled()) {
            this.underlying.error(message);
        }
    }

    public void error(String message, Throwable cause) {
        if (this.underlying.isErrorEnabled()) {
            this.underlying.error(message, cause);
        }
    }

    public void error(Marker marker, String message) {
        if (this.underlying.isErrorEnabled(marker)) {
            this.underlying.error(marker, message);
        }
    }

    public void error(Marker marker, String message, Throwable cause) {
        if (this.underlying.isErrorEnabled(marker)) {
            this.underlying.error(marker, message, cause);
        }
    }

    public void errorWith(String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isErrorEnabled()) {
                this.underlying.error(message);
            }
        } else if (this.underlying.isErrorEnabled()) {
            this.underlying.error(message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }

    public void errorWith(Marker marker, String message, Seq<Object> args) {
        if (args.isEmpty()) {
            if (this.underlying.isErrorEnabled(marker)) {
                this.underlying.error(marker, message);
            }
        } else if (this.underlying.isErrorEnabled(marker)) {
            this.underlying.error(marker, message, (Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
    }
}

