/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.Try$;
import com.twitter.util.security.X509CertificateDeserializer$;
import com.twitter.util.security.X509CertificateFile$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.cert.X509Certificate;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class X509CertificateFile {
    private final File file;

    public X509CertificateFile(File file) {
        this.file = file;
    }

    private void logException(Throwable ex) {
        X509CertificateFile$.com$twitter$util$security$X509CertificateFile$$$log.warning("X509Certificate (" + this.file.getName() + ") failed to load: " + ex.getMessage() + ".", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public Try<X509Certificate> readX509Certificate() {
        return Try$.MODULE$.apply(this::readX509Certificate$$anonfun$1).flatMap((Function1 & Serializable)buffered -> X509CertificateDeserializer$.MODULE$.deserializeCertificate((String)buffered, this.file.getName())).onFailure((Function1)(JProcedure1 & Serializable)ex -> this.logException((Throwable)ex));
    }

    public Try<Seq<X509Certificate>> readX509Certificates() {
        return Try$.MODULE$.apply(this::readX509Certificates$$anonfun$1).flatMap((Function1 & Serializable)buffered -> X509CertificateDeserializer$.MODULE$.deserializeCertificates((String)buffered, this.file.getName())).onFailure((Function1)(JProcedure1 & Serializable)ex -> this.logException((Throwable)ex));
    }

    private final String readX509Certificate$$anonfun$1() {
        return new String(Files.readAllBytes(this.file.toPath()), StandardCharsets.UTF_8);
    }

    private final String readX509Certificates$$anonfun$1() {
        return new String(Files.readAllBytes(this.file.toPath()), StandardCharsets.UTF_8);
    }
}

