/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.routing;

import com.twitter.util.routing.Generator;
import com.twitter.util.routing.Router;
import com.twitter.util.routing.RouterBuilder$;
import com.twitter.util.routing.RouterInfo$;
import com.twitter.util.routing.ValidationError;
import com.twitter.util.routing.ValidationException$;
import com.twitter.util.routing.Validator;
import java.io.Serializable;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.Queue;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class RouterBuilder<Input, Route, RouterType extends Router<Input, Route>>
implements Product,
Serializable {
    private final Generator generator;
    private final String label;
    private final Queue routes;
    private final Validator validator;

    public static RouterBuilder fromProduct(Product product) {
        return RouterBuilder$.MODULE$.fromProduct(product);
    }

    public static <Input, Route, RouterType extends Router<Input, Route>> RouterBuilder<Input, Route, RouterType> newBuilder(Generator<Input, Route, RouterType> generator) {
        return RouterBuilder$.MODULE$.newBuilder(generator);
    }

    public static <Input, Route, RouterType extends Router<Input, Route>> RouterBuilder<Input, Route, RouterType> unapply(RouterBuilder<Input, Route, RouterType> routerBuilder) {
        return RouterBuilder$.MODULE$.unapply(routerBuilder);
    }

    public RouterBuilder(Generator<Input, Route, RouterType> generator, String label, Queue<Route> routes, Validator<Route> validator) {
        this.generator = generator;
        this.label = label;
        this.routes = routes;
        this.validator = validator;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RouterBuilder)) return false;
        RouterBuilder routerBuilder = (RouterBuilder)object;
        Generator<Input, Route, RouterType> generator = this.generator();
        Generator<Input, Route, RouterType> generator2 = routerBuilder.generator();
        if (generator == null) {
            if (generator2 != null) {
                return false;
            }
        } else if (!generator.equals(generator2)) return false;
        String string = this.label();
        String string2 = routerBuilder.label();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Queue<Route> queue = this.routes();
        Queue<Route> queue2 = routerBuilder.routes();
        if (queue == null) {
            if (queue2 != null) {
                return false;
            }
        } else if (!queue.equals(queue2)) return false;
        Validator<Route> validator = this.validator();
        Validator<Route> validator2 = routerBuilder.validator();
        if (validator == null) {
            if (validator2 != null) {
                return false;
            }
        } else if (!validator.equals(validator2)) return false;
        if (!routerBuilder.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RouterBuilder;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "RouterBuilder";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "generator";
                break;
            }
            case 1: {
                string = "label";
                break;
            }
            case 2: {
                string = "routes";
                break;
            }
            case 3: {
                string = "validator";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    private Generator<Input, Route, RouterType> generator() {
        return this.generator;
    }

    private String label() {
        return this.label;
    }

    private Queue<Route> routes() {
        return this.routes;
    }

    private Validator<Route> validator() {
        return this.validator;
    }

    public RouterBuilder<Input, Route, RouterType> withLabel(String label) {
        return this.copy(this.copy$default$1(), label, this.copy$default$3(), this.copy$default$4());
    }

    public RouterBuilder<Input, Route, RouterType> withRoute(Route route) {
        Queue queue = (Queue)this.routes().$colon$plus(route);
        Generator<Input, Route, RouterType> generator = this.copy$default$1();
        String string = this.copy$default$2();
        Validator<Route> validator = this.copy$default$4();
        return this.copy(generator, string, queue, validator);
    }

    public RouterBuilder<Input, Route, RouterType> withValidator(Validator<Route> validator) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), validator);
    }

    public RouterType newRouter() {
        Iterable failures = (Iterable)this.validator().apply(this.routes());
        if (failures.nonEmpty()) {
            throw ValidationException$.MODULE$.apply((Iterable<ValidationError>)failures);
        }
        return (RouterType)((Router)this.generator().apply(RouterInfo$.MODULE$.apply(this.label(), this.routes())));
    }

    private <Input, Route, RouterType extends Router<Input, Route>> RouterBuilder<Input, Route, RouterType> copy(Generator<Input, Route, RouterType> generator, String label, Queue<Route> routes, Validator<Route> validator) {
        return new RouterBuilder<Input, Route, RouterType>(generator, label, routes, validator);
    }

    private <Input, Route, RouterType extends Router<Input, Route>> Generator<Input, Route, RouterType> copy$default$1() {
        return this.generator();
    }

    private <Input, Route, RouterType extends Router<Input, Route>> String copy$default$2() {
        return this.label();
    }

    private <Input, Route, RouterType extends Router<Input, Route>> Queue<Route> copy$default$3() {
        return this.routes();
    }

    private <Input, Route, RouterType extends Router<Input, Route>> Validator<Route> copy$default$4() {
        return this.validator();
    }

    public Generator<Input, Route, RouterType> _1() {
        return this.generator();
    }

    public String _2() {
        return this.label();
    }

    public Queue<Route> _3() {
        return this.routes();
    }

    public Validator<Route> _4() {
        return this.validator();
    }
}

